/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Simple program for showing a sprite until pressing space key */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <vgagames.h>

int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  grafik * grf;
  sprite * spr;
  int i1,x,y;

  /* open window */
  if (open_window("Sprite",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* load sprite */
  spr=NULL;
  for (i1=1;i1<argc;i1++) {
    if (argv[i1][0]!='-') {
      if ((spr=load_sprite(argv[i1]))==NULL) {
        end_err(argv[0],"load sprite");
      } else {break;}
    }
  }
  if (spr==NULL) {
    snprintf(errmsg,sizeof(errmsg),"\nCall: %s <sprite file>",argv[0]);
    end_err(argv[0],"no sprite file found to load");
  }

  /* if you want to rotate the sprite */
#if 0
  {sprite * rotspr=rotate_sprite(spr,90);
   free_sprite(spr);
   spr=rot_spr;
  }
#endif

  /* loops: show sprite */
  i1=0;
  do {
    if ((grf=next_sprite(spr,&x,&y))==NULL) {i1=1; break;}  /* get graphic */
    CLEAR_BOX(NULL,RGB_BLACK);
    copy_grafik(NULL,(SC_WIDTH-GRAFIK_WIDTH(grf))/2+x,(SC_HEIGHT-GRAFIK_HEIGHT(grf))/2+y,grf,0,0,0,0,RGB_FULL);
    flush_window();
  } while (get_space(50)==0);  /* loop time: 50 ms */
  printf("sprite width,height: %d,%d\n",SPRITE_WIDTH(spr),SPRITE_HEIGHT(spr));

  /* free sprite */
  free_sprite(spr);

  /* do ending */
  close_window();
  if (i1==1) {printf("Sprite empty\n");}
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
