/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Sound functions"
**   play 2 midi files with various options and show what is happening.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <vgagames.h>

int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  int wv[2];

  /* open window */
  if (open_window("Example",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* start sound server */
  /* as we will not load any wave but only midi files, we can set the
     sound settings freely (samplefrequnce 22050 and stereo)
  */
  if (init_sound(22050,1)==-1) {end_err(argv[0],"sound server");}

  /* load music files */
  if ((wv[0]=load_wave("./phatjail.mid",TYP_IS_MIDI))==0) {  /* music1 */
    end_err(argv[0],"load music");
  }
  if ((wv[1]=load_wave("./falls.mid",TYP_IS_MIDI))==0) {  /* music2 */
    end_err(argv[0],"load music");
  }

  /* play music1 at channel 1 */
  play_wave(wv[0],CN_(1),0,0);  /* play once with full volume */
  draw_text(NULL,RGB_WHITE,0,0,"Music 1 at channel 1 playing",28,RGB_FULL);
  flush_window();
  sleep(10);

  /* end playing music1 at channel 1 and start music2 at channel 2 */
  stop_wave(CN_(1),10);  /* end at channel 1 with decreasing volume (10 sec) */
  play_wave(wv[1],CN_(2),0,10);  /* play once with increasing volume (10 sec) */
  draw_text(NULL,RGB_WHITE,0,20,"Music 1 at channel 1 stopping",29,RGB_FULL);
  draw_text(NULL,RGB_WHITE,0,30,"Music 2 at channel 2 starting",29,RGB_FULL);
  flush_window();
  sleep(10);
  draw_text(NULL,RGB_WHITE,0,40,"Music 2 at channel 2 playing",28,RGB_FULL);
  flush_window();
  sleep(10);

  /* start music1 at channel 2 stopping music2 within 10 sec */
  play_wave(wv[0],CN_(2),1,10);  /* loop playing with increasing volume (10 sec) */
  draw_text(NULL,RGB_WHITE,0,60,"Music 2 at channel 2 stopping",29,RGB_FULL);
  draw_text(NULL,RGB_WHITE,0,70,"Music 1 at channel 2 starting",29,RGB_FULL);
  flush_window();
  sleep(20);
  draw_text(NULL,RGB_WHITE,0,80,"Music 1 at channel 2 playing",28,RGB_FULL);
  flush_window();
  sleep(10);

  /* pause and continue music1 at channel 2 */
  pause_wave(CN_(2));
  draw_text(NULL,RGB_WHITE,0,100,"Music 1 paused",14,RGB_FULL);
  flush_window();
  sleep(3);
  continue_wave(CN_(2));
  draw_text(NULL,RGB_WHITE,0,110,"Music 1 continued",17,RGB_FULL);
  flush_window();
  sleep(5);

  /* lower down quality */
  /* we set samplefrequence to a half and all to mono */
  accel_wave(2,1);
  /* we have to start music again because accel_wave() stops all */
  play_wave(wv[0],CN_(2),1,0);  /* loop playing with full volume */
  draw_text(NULL,RGB_WHITE,0,130,"Music 1 playing with less quality",33,RGB_FULL);
  flush_window();
  sleep(10);

  /* set original quality */
  accel_wave(1,2);
  /* we have to start music again because accel_wave() stops all */
  play_wave(wv[0],CN_(2),1,0);  /* loop playing with full volume */
  draw_text(NULL,RGB_WHITE,0,140,"Music 1 playing with original quality",37,RGB_FULL);
  flush_window();
  sleep(5);

  get_space(0);

  /* do ending */
  end_sound();  /* end sound server */
  close_window();
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    draw_text(NULL,RGB_WHITE,0,180,"Press Space",11,RGB_FULL);
    flush_window();
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  end_sound();
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
