/* font8x8=default font: width and height has 8 pixels
** each line is an image of an ASCII character
** each byte value represents 8 pixels of a row
** the first is the highest row, the last the lowest row
** It is the same format as produced by "atobm (1x)"
**
** Example:
** Letter "K" (8x8):
**     col: 1 2 3 4 5 6 7 8
**   row:                                    (col 8-1)
**    1     - # # - - # # -    --> bit value 01100110  = byte value 0x66
**    2     - # # - # # - -    --> bit value 00110110  = byte value 0x36
**    3     - # # # # - - -    --> bit value 00011110  = byte value 0x1e
**    4     - # # # - - - -    --> bit value 00001110  = byte value 0x0e
**    5     - # # # # - - -    --> bit value 00011110  = byte value 0x1e
**    6     - # # - # # - -    --> bit value 00110110  = byte value 0x36
**    7     - # # - - # # -    --> bit value 01100110  = byte value 0x66
**    8     - - - - - - - -    --> bit value 00000000  = byte value 0x00
*/

static unsigned char font8x8[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x7e,0x81,0xa5,0x81,0xbd,0x81,0x7e,0x00,
  0x7e,0xff,0xdb,0xff,0xc3,0xff,0x7e,0x00,
  0x6c,0xfe,0xfe,0xfe,0x7c,0x38,0x10,0x00,
  0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,
  0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,
  0x10,0x38,0x7c,0xfe,0x7c,0x10,0x38,0x7c,
  0x00,0x00,0x18,0x3c,0x3c,0x18,0x00,0x00,
  0xff,0xff,0xe7,0xc3,0xc3,0xe7,0xff,0xff,
  0x00,0x3c,0x66,0x42,0x42,0x66,0x3c,0x00,
  0xff,0xc3,0x99,0xbd,0xbd,0x99,0xc3,0xff,
  0xf0,0xe0,0xb0,0x3c,0x66,0x66,0x66,0x3c,
  0x3c,0x66,0x66,0x66,0x3c,0x18,0x7e,0x18,
  0x0c,0x1c,0x3c,0x6c,0x2c,0x0e,0x0f,0x07,
  0xfe,0xc6,0xfe,0xc6,0xc6,0xe6,0x67,0x03,
  0x18,0xdb,0x7e,0x66,0x66,0x7e,0xdb,0x18,
  0x02,0x0e,0x3e,0xfe,0x3e,0x0e,0x02,0x00,
  0x80,0xe0,0xf8,0xfe,0xf8,0xe0,0x80,0x00,
  0x18,0x3c,0x7e,0x18,0x18,0x7e,0x3c,0x18,
  0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00,
  0xfc,0x5e,0x5e,0x5c,0x50,0x50,0x50,0x00,
  0x78,0xcc,0x38,0x6c,0x6c,0x38,0x66,0x3c,
  0x00,0x00,0x00,0x00,0x7e,0x7e,0x7e,0x00,
  0x18,0x3c,0x7e,0x18,0x7e,0x3c,0x18,0x7e,
  0x18,0x3c,0x7e,0x18,0x18,0x18,0x18,0x00,
  0x18,0x18,0x18,0x18,0x7e,0x3c,0x18,0x00,
  0x00,0x30,0x70,0xfe,0x70,0x30,0x00,0x00,
  0x00,0x18,0x1c,0xfe,0x1c,0x18,0x00,0x00,
  0x00,0x00,0x06,0x06,0x06,0xfe,0x00,0x00,
  0x00,0x24,0x66,0xff,0x66,0x24,0x00,0x00,
  0x00,0x18,0x3c,0x7e,0xff,0xff,0x00,0x00,
  0x00,0xff,0xff,0x7e,0x3c,0x18,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x00,
  0x66,0x66,0x66,0x00,0x00,0x00,0x00,0x00,
  0x36,0x36,0x7f,0x36,0x7f,0x36,0x36,0x00,
  0x08,0x3e,0x0b,0x3e,0x68,0x3e,0x08,0x00,
  0x00,0x63,0x33,0x18,0x0c,0x66,0x63,0x00,
  0x1c,0x36,0x1c,0x6e,0x3b,0x33,0x6e,0x00,
  0x18,0x18,0x0c,0x00,0x00,0x00,0x00,0x00,
  0x30,0x18,0x0c,0x0c,0x0c,0x18,0x30,0x00,
  0x0c,0x18,0x30,0x30,0x30,0x18,0x0c,0x00,
  0x00,0x36,0x1c,0x7f,0x1c,0x36,0x00,0x00,
  0x00,0x18,0x18,0x7e,0x18,0x18,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x0c,
  0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,
  0x00,0x60,0x30,0x18,0x0c,0x06,0x03,0x00,
  0x3c,0x66,0x76,0x7e,0x6e,0x66,0x3c,0x00,
  0x30,0x38,0x3c,0x30,0x30,0x30,0x30,0x00,
  0x3c,0x66,0x60,0x38,0x0c,0x06,0x7e,0x00,
  0x3c,0x66,0x60,0x38,0x60,0x66,0x3c,0x00,
  0x38,0x3c,0x36,0x33,0x7f,0x30,0x30,0x00,
  0x7e,0x06,0x06,0x3e,0x60,0x66,0x3c,0x00,
  0x3c,0x06,0x06,0x3e,0x66,0x66,0x3c,0x00,
  0x7e,0x60,0x60,0x30,0x18,0x0c,0x0c,0x00,
  0x3c,0x66,0x66,0x3c,0x66,0x66,0x3c,0x00,
  0x3c,0x66,0x66,0x7c,0x60,0x60,0x3c,0x00,
  0x00,0x0c,0x0c,0x00,0x00,0x0c,0x0c,0x00,
  0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x0c,
  0x30,0x18,0x0c,0x06,0x0c,0x18,0x30,0x00,
  0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,
  0x0c,0x18,0x30,0x60,0x30,0x18,0x0c,0x00,
  0x3c,0x66,0x60,0x30,0x18,0x00,0x18,0x00,
  0x3c,0x66,0x76,0x76,0x36,0x06,0x3c,0x00,
  0x18,0x3c,0x66,0x66,0x7e,0x66,0x66,0x00,
  0x3e,0x66,0x66,0x3e,0x66,0x66,0x3e,0x00,
  0x3c,0x66,0x06,0x06,0x06,0x66,0x3c,0x00,
  0x3e,0x66,0x66,0x66,0x66,0x66,0x3e,0x00,
  0x7e,0x06,0x06,0x3e,0x06,0x06,0x7e,0x00,
  0x7e,0x06,0x06,0x3e,0x06,0x06,0x06,0x00,
  0x3c,0x66,0x06,0x76,0x66,0x66,0x3c,0x00,
  0x66,0x66,0x66,0x7e,0x66,0x66,0x66,0x00,
  0x3c,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,
  0x60,0x60,0x60,0x60,0x66,0x66,0x3c,0x00,
  0x66,0x36,0x1e,0x0e,0x1e,0x36,0x66,0x00,
  0x06,0x06,0x06,0x06,0x06,0x06,0x7e,0x00,
  0x63,0x77,0x7f,0x6b,0x63,0x63,0x63,0x00,
  0x66,0x6e,0x7e,0x76,0x66,0x66,0x66,0x00,
  0x3c,0x66,0x66,0x66,0x66,0x66,0x3c,0x00,
  0x3e,0x66,0x66,0x3e,0x06,0x06,0x06,0x00,
  0x3c,0x66,0x66,0x66,0x66,0x76,0x3c,0x60,
  0x3e,0x66,0x66,0x3e,0x66,0x66,0x66,0x00,
  0x3c,0x66,0x06,0x3c,0x60,0x66,0x3c,0x00,
  0x7e,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
  0x66,0x66,0x66,0x66,0x66,0x66,0x3c,0x00,
  0x66,0x66,0x66,0x66,0x66,0x3c,0x18,0x00,
  0x63,0x63,0x63,0x6b,0x7f,0x77,0x63,0x00,
  0x66,0x66,0x3c,0x18,0x3c,0x66,0x66,0x00,
  0x66,0x66,0x66,0x3c,0x18,0x18,0x18,0x00,
  0x7e,0x60,0x30,0x18,0x0c,0x06,0x7e,0x00,
  0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,0x3c,0x00,
  0x00,0x03,0x06,0x0c,0x18,0x30,0x60,0x00,
  0x3c,0x30,0x30,0x30,0x30,0x30,0x3c,0x00,
  0x18,0x3c,0x66,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
  0x18,0x18,0x30,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x06,0x06,0x06,0x3e,0x66,0x66,0x3e,0x00,
  0x00,0x00,0x3c,0x66,0x06,0x66,0x3c,0x00,
  0x60,0x60,0x60,0x7c,0x66,0x66,0x7c,0x00,
  0x00,0x00,0x3c,0x66,0x7e,0x06,0x7c,0x00,
  0x38,0x6c,0x0c,0x3e,0x0c,0x0c,0x0c,0x00,
  0x00,0x00,0x7c,0x66,0x66,0x7c,0x60,0x3c,
  0x06,0x06,0x3e,0x66,0x66,0x66,0x66,0x00,
  0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,
  0x30,0x00,0x30,0x30,0x30,0x30,0x36,0x1c,
  0x06,0x06,0x66,0x36,0x1e,0x36,0x66,0x00,
  0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x18,0x00,
  0x00,0x00,0x37,0x7f,0x6b,0x6b,0x63,0x00,
  0x00,0x00,0x3e,0x66,0x66,0x66,0x66,0x00,
  0x00,0x00,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x00,0x00,0x3e,0x66,0x66,0x3e,0x06,0x06,
  0x00,0x00,0x7c,0x66,0x66,0x7c,0x60,0x60,
  0x00,0x00,0x3e,0x66,0x06,0x06,0x06,0x00,
  0x00,0x00,0x7c,0x06,0x3c,0x60,0x3e,0x00,
  0x0c,0x0c,0x3e,0x0c,0x0c,0x6c,0x38,0x00,
  0x00,0x00,0x66,0x66,0x66,0x66,0x7c,0x00,
  0x00,0x00,0x66,0x66,0x66,0x3c,0x18,0x00,
  0x00,0x00,0x63,0x6b,0x7f,0x77,0x22,0x00,
  0x00,0x00,0x66,0x3c,0x18,0x3c,0x66,0x00,
  0x00,0x00,0x66,0x66,0x66,0x7c,0x60,0x3c,
  0x00,0x00,0x7e,0x30,0x18,0x0c,0x7e,0x00,
  0x38,0x0c,0x0c,0x06,0x0c,0x0c,0x38,0x00,
  0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
  0x1c,0x30,0x30,0x60,0x30,0x30,0x1c,0x00,
  0x00,0x00,0x00,0x6e,0x3b,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x0c,
  0x70,0xd8,0x18,0x3c,0x18,0x18,0x1e,0x0c,
  0x00,0x00,0x00,0x00,0x00,0xcc,0x66,0x33,
  0x00,0x00,0x00,0x00,0x00,0x54,0x54,0x00,
  0x00,0x08,0x3e,0x08,0x08,0x08,0x08,0x00,
  0x00,0x08,0x3e,0x08,0x08,0x3e,0x08,0x00,
  0x18,0x24,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xc3,0x33,0x0c,0x03,0xcc,0xcc,0x00,
  0x14,0x08,0x7c,0x02,0x3c,0x40,0x40,0x3e,
  0x00,0x18,0x0c,0x06,0x0c,0x18,0x00,0x00,
  0x00,0xfc,0x12,0xf2,0x12,0x12,0xfc,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x06,0x0c,0x18,0x00,0x00,0x00,0x00,0x00,
  0x30,0x18,0x0c,0x00,0x00,0x00,0x00,0x00,
  0x33,0x66,0xcc,0x00,0x00,0x00,0x00,0x00,
  0xcc,0x66,0x33,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x1c,0x1c,0x1c,0x00,0x00,0x00,
  0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,
  0x6e,0x3b,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xdf,0xaa,0x8a,0x00,0x00,0x00,0x00,
  0x00,0x14,0x08,0x7c,0x02,0x3c,0x40,0x3e,
  0x00,0x18,0x30,0x60,0x30,0x18,0x00,0x00,
  0x00,0x00,0xfc,0x92,0xf2,0x12,0xfc,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x66,0x00,0x66,0x66,0x3c,0x18,0x18,0x3c,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,
  0x30,0x30,0x7c,0x06,0x06,0x7c,0x30,0x30,
  0x1c,0x36,0x06,0x0f,0x06,0x66,0x3f,0x00,
  0x00,0x42,0x3c,0x24,0x3c,0x42,0x00,0x00,
  0x66,0x66,0x3c,0x18,0x7e,0x18,0x7e,0x18,
  0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00,
  0x78,0xcc,0x38,0x6c,0x6c,0x38,0x66,0x3c,
  0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x7e,0xb9,0x85,0x85,0xb9,0x7e,0x00,
  0x7c,0x66,0x66,0x7c,0x00,0x7e,0x00,0x00,
  0x00,0x6c,0x36,0x1b,0x36,0x6c,0x00,0x00,
  0x00,0x00,0x00,0x7f,0x40,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,
  0x00,0x7e,0xbd,0xbd,0x95,0xa5,0x7e,0x00,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x3c,0x66,0x66,0x3c,0x00,0x7e,0x00,0x00,
  0x18,0x18,0x7e,0x18,0x18,0x00,0x7e,0x00,
  0x3c,0x30,0x18,0x3c,0x00,0x00,0x00,0x00,
  0x3c,0x38,0x38,0x3c,0x00,0x00,0x00,0x00,
  0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x66,0x66,0x66,0x66,0xfe,0x03,
  0xfe,0x51,0x5e,0x50,0x50,0x50,0xfc,0x00,
  0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x3c,
  0x18,0x14,0x10,0x10,0x00,0x00,0x00,0x00,
  0x3c,0x66,0x66,0x3c,0x00,0x00,0x00,0x00,
  0x00,0x1b,0x36,0x6c,0x36,0x1b,0x00,0x00,
  0x63,0x33,0x1b,0x6c,0x76,0x6b,0xf8,0x60,
  0x63,0x33,0x1b,0x7c,0xc6,0x63,0x30,0xf8,
  0x67,0x36,0x1f,0x6c,0x76,0x6b,0xf8,0x60,
  0x18,0x00,0x18,0x0c,0x06,0x66,0x3c,0x00,
  0x18,0x30,0x3c,0x66,0x7e,0x66,0x66,0x00,
  0x30,0x18,0x3c,0x66,0x7e,0x66,0x66,0x00,
  0x3c,0x66,0x3c,0x66,0x7e,0x66,0x66,0x00,
  0xd8,0x36,0x3c,0x66,0x7e,0x66,0x66,0x00,
  0x63,0x1c,0x36,0x63,0x7f,0x63,0x63,0x00,
  0x18,0x18,0x3c,0x66,0x7e,0x66,0x66,0x00,
  0x7c,0x1e,0x1b,0x7b,0x1f,0x1b,0x7b,0x00,
  0x3c,0x66,0x06,0x06,0x66,0x3c,0x18,0x0c,
  0x0c,0x18,0x3e,0x06,0x1e,0x06,0x3e,0x00,
  0x30,0x18,0x3e,0x06,0x1e,0x06,0x3e,0x00,
  0x3c,0x66,0x3e,0x06,0x1e,0x06,0x3e,0x00,
  0x36,0x00,0x3e,0x06,0x1e,0x06,0x3e,0x00,
  0x18,0x30,0x3c,0x18,0x18,0x18,0x3c,0x00,
  0x18,0x0c,0x3c,0x18,0x18,0x18,0x3c,0x00,
  0x3c,0x66,0x3c,0x18,0x18,0x18,0x3c,0x00,
  0x66,0x3c,0x18,0x18,0x18,0x18,0x3c,0x00,
  0x00,0x3e,0x66,0x6f,0x6f,0x66,0x3e,0x00,
  0x7e,0x00,0x66,0x6e,0x7e,0x76,0x66,0x00,
  0x0c,0x18,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x30,0x18,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x3c,0x66,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0xdc,0x76,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x66,0x3c,0x66,0x66,0x66,0x66,0x3c,0x00,
  0x00,0x00,0x24,0x18,0x18,0x24,0x00,0x00,
  0x80,0x7c,0x66,0x76,0x6e,0x66,0x3e,0x01,
  0x0c,0x18,0x66,0x66,0x66,0x66,0x3c,0x00,
  0x30,0x18,0x66,0x66,0x66,0x66,0x3c,0x00,
  0x3c,0x66,0x00,0x66,0x66,0x66,0x3c,0x00,
  0x66,0x00,0x66,0x66,0x66,0x66,0x3c,0x00,
  0x30,0x18,0x66,0x66,0x3c,0x18,0x18,0x3c,
  0x00,0x07,0x1e,0x22,0x22,0x1e,0x07,0x00,
  0x3c,0x66,0x66,0x3e,0x66,0x66,0x3e,0x06,
  0x0c,0x18,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x30,0x18,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x3c,0x66,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x6e,0x3b,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x66,0x00,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x18,0x18,0x3c,0x60,0x7c,0x66,0x7c,0x00,
  0x00,0x00,0x7e,0x58,0x7e,0x1b,0x7e,0x00,
  0x00,0x00,0x7c,0x06,0x06,0x7c,0x18,0x0c,
  0x0c,0x18,0x3c,0x66,0x7e,0x06,0x3c,0x00,
  0x30,0x18,0x3c,0x66,0x7e,0x06,0x3c,0x00,
  0x3c,0x66,0x3c,0x66,0x7e,0x06,0x3c,0x00,
  0x66,0x00,0x3c,0x66,0x7e,0x06,0x3c,0x00,
  0x0e,0x00,0x18,0x18,0x18,0x18,0x18,0x00,
  0x70,0x00,0x18,0x18,0x18,0x18,0x18,0x00,
  0x3c,0x66,0x18,0x18,0x18,0x18,0x18,0x00,
  0x66,0x00,0x18,0x18,0x18,0x18,0x18,0x00,
  0x78,0x0c,0x18,0x3c,0x66,0x66,0x3c,0x00,
  0x6e,0x3b,0x00,0x3e,0x66,0x66,0x66,0x00,
  0x0c,0x18,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x30,0x18,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x3c,0x66,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0xdc,0x76,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x66,0x00,0x3c,0x66,0x66,0x66,0x3c,0x00,
  0x18,0x18,0x00,0x7e,0x00,0x18,0x18,0x00,
  0x00,0x40,0x3c,0x76,0x6e,0x66,0x3e,0x01,
  0x0c,0x18,0x66,0x66,0x66,0x66,0x7c,0x00,
  0x30,0x18,0x66,0x66,0x66,0x66,0x7c,0x00,
  0x3c,0x66,0x00,0x66,0x66,0x66,0x7c,0x00,
  0x66,0x00,0x66,0x66,0x66,0x66,0x7c,0x00,
  0x30,0x18,0x66,0x66,0x66,0x7c,0x60,0x3c,
  0x07,0x02,0x1e,0x22,0x22,0x1e,0x02,0x07,
  0x66,0x00,0x66,0x66,0x66,0x7c,0x60,0x3c
};
