#!/bin/sh

w_conf="/usr/share/vgagames/wave.conf"

c_lib=`grep '^LIB=' $w_conf 2> /dev/null`
c_pcm_dev=`grep '^PCM-DEVICE=' $w_conf 2> /dev/null`
c_mixer_dev=`grep '^MIXER-DEVICE=' $w_conf 2> /dev/null`
c_para_s=`grep '^PARA-S=' $w_conf 2> /dev/null`
c_debugfile=`grep '^DEBUGFILE=' $w_conf 2> /dev/null`

cat <<__CEND__
#
# Configuration file for vgag-wave
#

# LIB=<name>
# uncommenting one (and only one) of following lines means:
# use this sound library,
# otherwise test and use the first valid sound library.
# See 'vgag-wave -h' for a list of sound libraries which are compiled in

#LIB=OSS         # use OSS
#LIB=ALSA09      # use ALSA since 0.9 rc4
#LIB=SUN-AUDIO   # use Sun audio
$c_lib

# PCM-DEVICE=<device name>
# if uncommented use this device for pcm output
# else default device is used

#PCM-DEVICE=/dev/dsp   # for OSS
#PCM-DEVICE=hw:0       # for ALSA 0.9
#PCM-DEVICE=/dev/audio # for Sun audio
$c_pcm_dev

# MIXER-DEVICE=<device name>
# if uncommented use this device for mixer settings (volume)
# else default device is used

#MIXER-DEVICE=/dev/mixer   # for OSS
#MIXER-DEVICE=hw:0         # for ALSA 0.9
#MIXER-DEVICE=/dev/mixer   # for Sun audio
$c_mixer_dev

# PARA-S=<samplefrequence><M|S>
# same as parameter "-s" to vgag-wave:
# start sound server with default settings
# - samplefrequence
# - [M]ono / [S]tereo
#
# Parameter "-s" overwrites these settings

#PARA-S=11025M
$c_para_s

# DEBUGFILE=<path+filename>
# if uncommented write sound server messages to file
# overwriting it every time the sound server is started

#DEBUGFILE=/tmp/vgag_ws.out
$c_debugfile
__CEND__
