/* soundserver.h: If sound device cannot be opened, try to stop running sound servers */

void soundserver(int *);
static int ssv_arts(int);
static int ssv_esd(int);


void soundserver(int * ssv) {
/* 1.arg: value=-1: stop sound server
**                  and set it to value for starting again
**        value==0: nothing
**        value>0: start previously stopped sound server
*/
  if (ssv==NULL) {return;}

  if (*ssv==-1) {  /* try to stop */
    if (ssv_arts(0)>0) {  /* artsd: value 1 */
      *ssv=1;
    } else if (ssv_esd(0)>0) {  /* esd: value 2 */
      *ssv=2;
    } else {*ssv=0;}

  } else if (*ssv>0) {  /* start sound server of given value */
    switch(*ssv) {
      case 1:  ssv_arts(1); break;
      case 2:  ssv_esd(1); break;
    }
  }
} /* Ende soundserver */


static int ssv_arts(int doit) {
/* stop or start arts sound server
** 1.arg: 0=stop it or 1=start it
** return value: stopping:  1=stopped or 0=not running
**               starting:  0
*/
  static int rate=44100,bits=16,asuspend=0,fragment=10,fragsize=4096;
  static char ameth[64]="";
  char buf[512],* ptr;
  FILE * pfp;
  int zl=0,i1,znr;
  if (doit==0) {
    for (znr=0;znr<2;znr++) {
      if (znr==0) {
        if ((pfp=popen("(echo \"status\"; echo \"terminate\") | artsshell 2> /dev/null","r"))==NULL) {continue;}
      } else {
        if ((pfp=popen("(echo \"status\"; echo \"terminate\") | /opt/kde3/bin/artsshell 2> /dev/null","r"))==NULL) {continue;}
      }
      while (fgets(buf,sizeof(buf),pfp)!=NULL) {
        if (((ptr=strstr(buf,"sampling rate:"))!=NULL) && ((i1=atoi(ptr+14))>0)) {
          rate=i1;
        } else if (((ptr=strstr(buf,"sample size:"))!=NULL) && ((i1=atoi(ptr+12))>0)) {
          bits=i1;
        } else if ((ptr=strstr(buf,"audio method:"))!=NULL) {
          strncpy(ameth,ptr+13,sizeof(ameth)-1); ameth[sizeof(ameth)-1]='\0';
          if (*(ptr=ameth+strlen(ameth)-1)=='\n') {*ptr='\0';}
        } else if (((ptr=strstr(buf,"auto supend time:"))!=NULL) && ((i1=atoi(ptr+17))>0)) {
          asuspend=i1;
        } else if (((ptr=strstr(buf,"fragments:"))!=NULL) && ((i1=atoi(ptr+10))>0)) {
          fragment=i1;
        } else if (((ptr=strstr(buf,"fragment size:"))!=NULL) && ((i1=atoi(ptr+14))>0)) {
          fragsize=i1;
        }
        zl++;
      }
      if (pclose(pfp)!=0) {zl=0;} else {break;}
    }
  } else {
    snprintf(buf,sizeof(buf),"artswrapper -r %d -b %d -a %s -s %d -F %d -S %d -f -l 3 &",rate,bits,ameth,asuspend,fragment,fragsize);
    system(buf);
  }
  return(!!zl);
} /* Ende ssv_arts */


static int ssv_esd(int doit) {
/* stop or start esd sound server
** 1.arg: 0=stop it or 1=start it
** return value: stopping:  1=stopped or 0=not running
**               starting:  0
*/
  int zl=0;
  if (doit==0) {
    if (system("esdctl off 2> /dev/null")==0) {zl=1;}
  } else {
    system("esdctl on 2> /dev/null");
  }
  return(zl);
} /* Ende ssv_esd */
