/*
  For vgagames modified from:
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2001 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include "tmidi.h"
#include "timer.h"

#if defined(nec_ews)
#ifndef GETTIMEOFDAY_ONE_ARGUMENT
#define GETTIMEOFDAY_ONE_ARGUMENT
#endif /* GETTIMEOFDAY_ONE_ARGUMENT */
#endif

double get_current_calender_time(void)
{
    struct timeval tv;
    struct timezone dmy;

#ifdef GETTIMEOFDAY_ONE_ARGUMENT
    gettimeofday(&tv);
#else
    gettimeofday(&tv, &dmy);
#endif

    return (double)tv.tv_sec + (double)tv.tv_usec / 1000000.0 ;
}
