/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* vgag-bitmap.c: convert a graphic to a vgagames graphic format */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

typedef struct {
  unsigned char r,g,b;
} farbkonv;
char errmsg[2048];

static FILE * _vga_grafik(const char *);
#include "vgag-bitmap.h"

int main(int argc,char ** argv) {
  FILE * HX,* HV;
  char buf[1024],grnam[1024],* p1;
  size_t anz;
  if ((argc!=2) || (argv[1][0]=='-')) {
    fprintf(stderr,"Converts a windows bitmap file or an ppm graphic file\n");
    fprintf(stderr,"into an vgagames graphic file.\n");
    fprintf(stderr,"The source graphic must have a color depth <= 256 colors.\n");
    fprintf(stderr,"Usage: %s <graphic-file>\n",argv[0]);
    fprintf(stderr,"Creates <graphic-file>.vga\n");
    fprintf(stderr,"Gives out colormap of vgagames graphic file.\n");
    exit(1);
  }
  if ((HX=_vga_grafik(argv[1]))==NULL) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }
  snprintf(grnam,sizeof(grnam),"%s.vga",argv[1]);
  if ((HV=fopen(grnam,"w"))==NULL) {
    fprintf(stderr,"%s: Cannot write graphic file \"%s\"\n",argv[0],grnam);
    fclose(HX);
    exit(1);
  }
  fseek(HX,0L,SEEK_SET);
  if ((anz=fread(buf,1,2+5+5,HX))==2+5+5) {
    fwrite(buf,1,anz,HV);
  } else {
    fprintf(stderr,"%s: Short read in graphic file \"%s\"\n",argv[0],grnam);
    fclose(HX);
    fclose(HV);
    unlink(grnam);
    exit(1);
  }
  if ((anz=fread(buf,1,256*3,HX))==256*3) {
    fwrite(buf,1,anz,HV);
  } else {
    fprintf(stderr,"%s: Short read in graphic file \"%s\"\n",argv[0],grnam);
    fclose(HX);
    fclose(HV);
    unlink(grnam);
    exit(1);
  }
  if ((p1=strrchr(grnam,'/'))!=NULL) {p1++;} else {p1=grnam;}
  printf("# Colormap for %s\n\n",p1);
  for (anz=0;anz<256;anz++) {
    printf("%d=%d %d %d\n",anz,buf[anz*3],buf[anz*3+1],buf[anz*3+2]);
  }
  while ((anz=fread(buf,1,sizeof(buf),HX))>0) {fwrite(buf,1,anz,HV);}
  fclose(HX);
  fclose(HV);
  fflush(stdout);
  fprintf(stderr,"%s:  %s --> %s.vga: OK\n",argv[0],argv[1],argv[1]);
  exit(0);
} /* Ende main */
