/* Include file for vgag-wave.c
** Used to include support for different sound devices.
** - write your own include file according to wave_oss.h,
** - include it in here dependend from a #define,
*/

/* ****** struct for sound functions ****** */

struct wave_device {  /* struct for functions according to sound library */
  int (*open_dev)(struct wave_device *);
  int (*config_dev)(struct wave_device *,unsigned long,unsigned long,unsigned long,unsigned long);
  void (*write_dev)(struct wave_device *,const unsigned char *,int);
  void (*close_dev)(struct wave_device *);
  int (*mixer_dev)(struct wave_device *,int,int);
  int simul_16,simul_stereo;
  const char * libname;
};


/* ****** some defines for access to struct wave_cf ****** */
#define OPEN_DEVICE_PCM  wave_cf.dev_pcm      /* if empty use default */
#define OPEN_DEVICE_MIXER  wave_cf.dev_mixer  /* if empty use default */


/* ****** include header files dep. from installed sound libr. ****** */
#include "_c_wave.h"

#ifdef C_WAVE__OSS   /* OSS support */
  #include "wave_oss.h"
#endif
#ifdef C_WAVE__ALSA09  /* ALSA 0.9 support */
  #include "wave_alsa09.h"
#endif
#ifdef C_WAVE__SAUDIO  /* Sun audio support */
  #include "wave_saudio.h"
#endif


/* ****** fill in functions dep. of installed sound libr. ****** */

struct wave_device w_dev[]={

#ifdef C_WAVE__OSS   /* OSS support */
  {
   open_oss,
   config_oss,
   write_oss,
   close_oss,
   mixer_oss,
   0,0,
   "OSS"
  },
#endif

#ifdef C_WAVE__ALSA09  /* ALSA 0.9 support */
  {
   open_alsa09,
   config_alsa09,
   write_alsa09,
   close_alsa09,
   mixer_alsa09,
   0,0,
   "ALSA09"
  },
#endif

#ifdef C_WAVE__SAUDIO  /* Sun audio support */
  {
   open_saudio,
   config_saudio,
   write_saudio,
   close_saudio,
   mixer_saudio,
   0,0,
   "SUN-AUDIO"
  },
#endif

  /* last line! */
  {NULL,NULL,NULL,NULL,NULL,0,0,NULL}
};
