/* Version 1.10
   Copyright (C) 2000-2005 Kurt Nienhaus */

#ifndef VGAGAMES_H_
#define VGAGAMES_H_

/* +++ general +++ */
#define SC_WIDTH 320
#define SC_HEIGHT 200

extern char errmsg[2048];  /* string for error message */

#include <vgagames_wave.h>


/* +++ key and mouse +++ */
#define KEYS_INDEX 73   /* number of keys defined */
#define KEY_0           0    /* 0 */
#define KEY_1           1    /* 1 */
#define KEY_2           2    /* 2 */
#define KEY_3           3    /* 3 */
#define KEY_4           4    /* 4 */
#define KEY_5           5    /* 5 */
#define KEY_6           6    /* 6 */
#define KEY_7           7    /* 7 */
#define KEY_8           8    /* 8 */
#define KEY_9           9    /* 9 */
#define KEY_A           10   /* A */
#define KEY_B           11   /* B */
#define KEY_C           12   /* C */
#define KEY_D           13   /* D */
#define KEY_E           14   /* E */
#define KEY_F           15   /* F */
#define KEY_G           16   /* G */
#define KEY_H           17   /* H */
#define KEY_I           18   /* I */
#define KEY_J           19   /* J */
#define KEY_K           20   /* K */
#define KEY_L           21   /* L */
#define KEY_M           22   /* M */
#define KEY_N           23   /* N */
#define KEY_O           24   /* O */
#define KEY_P           25   /* P */
#define KEY_Q           26   /* Q */
#define KEY_R           27   /* R */
#define KEY_S           28   /* S */
#define KEY_T           29   /* T */
#define KEY_U           30   /* U */
#define KEY_V           31   /* V */
#define KEY_W           32   /* W */
#define KEY_X           33   /* X */
#define KEY_Y           34   /* Y */
#define KEY_Z           35   /* Z */
#define KEY_KP_0        36   /* Keypad 0 */
#define KEY_KP_1        37   /* Keypad 1 */
#define KEY_KP_2        38   /* Keypad 2 */
#define KEY_KP_3        39   /* Keypad 3 */
#define KEY_KP_4        40   /* Keypad 4 */
#define KEY_KP_5        41   /* Keypad 5 */
#define KEY_KP_6        42   /* Keypad 6 */
#define KEY_KP_7        43   /* Keypad 7 */
#define KEY_KP_8        44   /* Keypad 8 */
#define KEY_KP_9        45   /* Keypad 9 */
#define KEY_ESC         46   /* Escape */
#define KEY_TAB         47   /* Tabulator */
#define KEY_RSHIFT      48   /* Right Shift */
#define KEY_LSHIFT      49   /* Left Shift */
#define KEY_RCTRL       50   /* Right Control */
#define KEY_LCTRL       51   /* Left Control */
#define KEY_RALT        52   /* Right Alt */
#define KEY_LALT        53   /* Left Alt */
#define KEY_SPACE       54   /* Space */
#define KEY_ENTER       55   /* Return */
#define KEY_BSP         56   /* Backspace */
#define KEY_RCURS       57   /* Right Cursor */
#define KEY_LCURS       58   /* Left Cursor */
#define KEY_UCURS       59   /* Up Cursor */
#define KEY_DCURS       60   /* Down Cursor */
#define KEY_F1          61   /* F1 */
#define KEY_F2          62   /* F2 */
#define KEY_F3          63   /* F3 */
#define KEY_F4          64   /* F4 */
#define KEY_F5          65   /* F5 */
#define KEY_F6          66   /* F6 */
#define KEY_F7          67   /* F7 */
#define KEY_F8          68   /* F8 */
#define KEY_F9          69   /* F9 */
#define KEY_F10         70   /* F10 */
#define KEY_F11         71   /* F11 */
#define KEY_F12         72   /* F12 */

extern int _keyi;              /* number of added keys with ADD_KEYS() */
extern int _keym[KEYS_INDEX];  /* key number and whether SHORT_- or LONG_KEY */
extern int _keyc[KEYS_INDEX];  /* whether key pressed or not */
extern int _maus_x,_maus_y,_maus_left,_maus_right,_maus_middle;

#define SHORT_KEY 0
#define LONG_KEY  1
#define CLEAR_KEYS      {int i; _keyi=0; for (i=0;i<KEYS_INDEX;i++) {_keyc[i]=3;}}
#define ADD_KEYS(A,B)   if ((_keyi<KEYS_INDEX) && (A<KEYS_INDEX)) {_keym[_keyi++]=(A|(B*8192)); _keyc[A]=3;}
#define IS_KEYS(A)      (A<KEYS_INDEX?(_keyc[A]==1?1:0):0)
#define SAVE_KEYS(A)    if (((A)=malloc(sizeof(int)*(KEYS_INDEX+1)))!=NULL) {memmove((A),_keym,sizeof(_keym)); (A)[KEYS_INDEX]=_keyi;}
#define RESTORE_KEYS(A) if ((A)!=NULL) {CLEAR_KEYS; memmove(_keym,(A),sizeof(_keym)); _keyi=(A)[KEYS_INDEX]; free(A);}
#define MOUSE_X        _maus_x
#define MOUSE_Y        _maus_y
#define IS_MOUSELEFT   (_maus_left==1?1:0)
#define IS_MOUSERIGHT  (_maus_right==1?1:0)
#define IS_MOUSEMIDDLE (_maus_middle==1?1:0)


/* +++ colors +++ */
#define COLOR_MAX   18  /* number of colors defined */
#define CL_RED             1
#define CL_REDORANGE       2
#define CL_ORANGE          3
#define CL_YELLOWORANGE    4
#define CL_YELLOW          5
#define CL_YELLOWGREEN     6
#define CL_GREEN           7
#define CL_TURQUOISEGREEN  8
#define CL_TURQUOISE       9
#define CL_TURQUOISEBLUE   10
#define CL_BLUE            11
#define CL_BLUEVIOLET      12
#define CL_VIOLET          13
#define CL_REDVIOLET       14
#define CL_PINK            15
#define CL_BROWN           16
#define CL_WHITE           17
#define CL_BLACK           18


/* +++ display +++ */
#define RGB256   "default"
#define GREY256  "grey"
extern int _rgb_black,_rgb_white,_rgb_dark;
#define RGB_BLACK _rgb_black
#define RGB_WHITE _rgb_white
#define RGB_DARK  _rgb_dark

#define RGB_FULL   1
#define RGB_TRANS  2

#define VGAWINDOW_1  1
#define VGAWINDOW_2  2
#define VGAWINDOW_3  3
#define VGAWINDOW_4  VGAWINDOW_3
#define VGAWINDOW_FULL 10
#define VGAWINDOW_NOSWITCH 20


/* +++ additional fonts +++ */
extern unsigned char font10x17[];


/* +++ graphics +++ */
typedef struct {
  unsigned char * pxm;  /* pixels */
  int width,height;     /* width and height of graphic */
} grafik;
extern grafik * backpuffer;

#define CLEAR_BOX(A,B)  { \
  grafik * g=A; \
  draw_fillbox(g,0,0,g==NULL?SC_WIDTH:g->width,g==NULL?SC_HEIGHT:g->height,B); \
}
#define GRAFIK_WIDTH(A)   ((A)!=NULL?(A)->width:backpuffer->width)
#define GRAFIK_HEIGHT(A)  ((A)!=NULL?(A)->height:backpuffer->height)


/* +++ moving graphics with sound (film) +++ */
typedef struct {  /* each picture of a sequence of a film */
  grafik * pic;             /* graphic */
  int count;                /* counter for steps graphic is shown */
  int count_to;             /* upto steps graphic to show */
  int x,y;                  /* relative x/y coordinates */
  int ft;                   /* RGB_FULL or RGB_TRANS */
  int wnr;                  /* wave number: play, or -1=stop or 0=do nothing */
  int wch;                  /* channel(s) sound to play/stop */
  short wvol;               /* time to in/decrease volume */
} film_bild;

typedef struct _film film;
struct _film {
  grafik ** _pixold,** _pixnew;      /* internal */
  void (*func)(film *,void *,int);   /* film subcall or NULL */
  film_bild *** bild;                /* pointer to sequences */
  int * aktiv;                       /* sequence active? see #defines below */
#define FILM_ACT_OK     0       /* sequence is active */
#define FILM_ACT_SLEEP  1       /* sequence is sleeping: only draw graphic */
#define FILM_ACT_DEAD   2       /* sequence is dead: don't even draw graphic */
  int * bildnr;                      /* current picture number of sequence */
  unsigned long step;                /* step number of film */
  int id,x,y;                        /* ID and x/y coordinates of film */
};

#define SET_FILM(P1,P2,P3,P4,P5)  \
     ((P1)->id=P2,(P1)->x=P3,(P1)->y=P4,(P1)->func=P5)
#define SET_FILM_BILD(P1,P2,P3,P4,P5,P6,P7,P8,P9)  \
     ((P1)->pic=P2,(P1)->x=P3,(P1)->y=P4,(P1)->ft=P5,(P1)->count_to=P6,(P1)->wnr=P7,(P1)->wch=P8,(P1)->wvol=P9)


/* +++ sprites (animated graphics) +++ */
typedef struct {
  int spr_pos,spr_anz;  /* actual graphic, number of graphics */
  int runde;            /* actual counter for graphic */
  int w_orig,h_orig;    /* size of first graphic */
  struct {              /* spr_anz elements of graphics */
    int maxrunde;         /* how long graphic remains */
    grafik * grf;         /* graphic */
  } * spr_ptr;
} sprite;
#define SPRITE_WIDTH(A)   ((A)!=NULL?(A)->w_orig:0)
#define SPRITE_HEIGHT(A)  ((A)!=NULL?(A)->h_orig:0)


/* +++ functions +++ */

/* general functions */
extern int wait_time(int);
extern int color_index(int,int);
extern int load_colormap(const char *);
extern void set_font(unsigned char *,int,int);
extern grafik * create_grafik(int,int);
extern grafik * load_grafik(const char *);
extern grafik * text_to_grafik(int,int,int,int,const char *);
extern int save_grafik_as_ppm(grafik *,const char *);
extern int save_grafik_as_ppm3(grafik *,const char *);
extern void free_grafik(grafik *);
extern void copy_grafik(grafik *,int,int,grafik *,int,int,int,int,int);
extern grafik * rotate_grafik(grafik *,grafik *,int,int *,int *,int *,int *);
extern grafik * zoom_grafik(grafik *,grafik *,float,float,int *,int *,int *,int *);
extern int get_pixel(grafik *,int,int);
extern void draw_text(grafik *,int,int,int,const char *,int,int);
extern void draw_pixel(grafik *,int,int,int);
extern void draw_line(grafik *,int,int,int,int,int);
extern void draw_circle(grafik *,int,int,int,int,int);
extern void draw_fillbox(grafik *,int,int,int,int,int);
extern film * create_film(int);
extern int add_bild_to_film(film *,film_bild *,int);
extern unsigned long copy_film(grafik *,film *,void *);
extern void reset_film(film *,void *,int);
extern void free_film(film *);
extern sprite * create_sprite(void);
extern sprite * load_sprite(const char *);
extern sprite * rotate_sprite(sprite *,int);
extern sprite * zoom_sprite(sprite *,float,float);
extern int add_grafik_to_sprite(sprite *,grafik *,int,int,int,int,int);
extern grafik * next_sprite(sprite *,int *,int *);
extern grafik * last_sprite(sprite *,int *,int *);
extern int reset_sprite(sprite *);
extern void free_sprite(sprite *);

/* graphic library dependend functions */
extern int open_window(const char *,int);
extern void flush_window(void);
extern void close_window(void);
extern int reopen_window(int);
extern void get_keys(void);
extern void clearstate(void);
extern int mouse_speed(int);
extern void brightness(int);

/* sound functions (sound.c) */
extern int init_sound(long,int);
extern int load_wave(const char *,int);
extern void play_wave(int,int,short,short);
extern void stop_wave(int,short);
extern void pause_wave(int);
extern void continue_wave(int);
extern void volume_wave(int,short);
extern void accel_wave(short,short);
extern void end_sound(void);
extern int set_vol(int,int);

/* network functions (nettcp.c) */
extern int start_nettcp(int,int,unsigned short);
extern void * connect_nettcp(const char *,unsigned short,size_t,int *,int *);
extern int talk_nettcp(void);
extern void close_nettcp(void);


/* +++ graphic libraries +++ */
#ifdef GRLIB_VGA
  #include <vgagames_vga.h>  /* svgalib */
#endif

#ifdef GRLIB_VGL
  #include <vgagames_vgl.h>  /* libvgl */
#endif

#ifdef GRLIB_X
  #include <vgagames_x.h>    /* X window */
#endif

#endif /* VGAGAMES_H_ */
