/* *****************************************************************
   Include-file for "vgagames.c": for graphic library "svgalib".
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */


/* +++ declarations +++ */

int _no_maus;

static int bp_doppl;
static GraphicsContext * pys;
static int _keyw[KEYS_INDEX];
static void _init_keys(void);


/* +++ internal functions +++ */

static void _init_keys() {
/* initalize keys, called from open_window()
** To Do:
** set _keyw[] to scancodes to compare it in get_keys() when pressed
*/
  _keyw[KEY_0]=SCANCODE_0;
  _keyw[KEY_1]=SCANCODE_1;
  _keyw[KEY_2]=SCANCODE_2;
  _keyw[KEY_3]=SCANCODE_3;
  _keyw[KEY_4]=SCANCODE_4;
  _keyw[KEY_5]=SCANCODE_5;
  _keyw[KEY_6]=SCANCODE_6;
  _keyw[KEY_7]=SCANCODE_7;
  _keyw[KEY_8]=SCANCODE_8;
  _keyw[KEY_9]=SCANCODE_9;
  _keyw[KEY_A]=SCANCODE_A;
  _keyw[KEY_B]=SCANCODE_B;
  _keyw[KEY_C]=SCANCODE_C;
  _keyw[KEY_D]=SCANCODE_D;
  _keyw[KEY_E]=SCANCODE_E;
  _keyw[KEY_F]=SCANCODE_F;
  _keyw[KEY_G]=SCANCODE_G;
  _keyw[KEY_H]=SCANCODE_H;
  _keyw[KEY_I]=SCANCODE_I;
  _keyw[KEY_J]=SCANCODE_J;
  _keyw[KEY_K]=SCANCODE_K;
  _keyw[KEY_L]=SCANCODE_L;
  _keyw[KEY_M]=SCANCODE_M;
  _keyw[KEY_N]=SCANCODE_N;
  _keyw[KEY_O]=SCANCODE_O;
  _keyw[KEY_P]=SCANCODE_P;
  _keyw[KEY_Q]=SCANCODE_Q;
  _keyw[KEY_R]=SCANCODE_R;
  _keyw[KEY_S]=SCANCODE_S;
  _keyw[KEY_T]=SCANCODE_T;
  _keyw[KEY_U]=SCANCODE_U;
  _keyw[KEY_V]=SCANCODE_V;
  _keyw[KEY_W]=SCANCODE_W;
  _keyw[KEY_X]=SCANCODE_X;
  _keyw[KEY_Y]=SCANCODE_Y;
  _keyw[KEY_Z]=SCANCODE_Z;
  _keyw[KEY_KP_0]=SCANCODE_KEYPAD0;
  _keyw[KEY_KP_1]=SCANCODE_KEYPAD1;
  _keyw[KEY_KP_2]=SCANCODE_KEYPAD2;
  _keyw[KEY_KP_3]=SCANCODE_KEYPAD3;
  _keyw[KEY_KP_4]=SCANCODE_KEYPAD4;
  _keyw[KEY_KP_5]=SCANCODE_KEYPAD5;
  _keyw[KEY_KP_6]=SCANCODE_KEYPAD6;
  _keyw[KEY_KP_7]=SCANCODE_KEYPAD7;
  _keyw[KEY_KP_8]=SCANCODE_KEYPAD8;
  _keyw[KEY_KP_9]=SCANCODE_KEYPAD9;
  _keyw[KEY_ESC]=SCANCODE_ESCAPE;
  _keyw[KEY_TAB]=SCANCODE_TAB;
  _keyw[KEY_RSHIFT]=SCANCODE_RIGHTSHIFT;
  _keyw[KEY_LSHIFT]=SCANCODE_LEFTSHIFT;
  _keyw[KEY_RCTRL]=SCANCODE_RIGHTCONTROL;
  _keyw[KEY_LCTRL]=SCANCODE_LEFTCONTROL;
  _keyw[KEY_RALT]=SCANCODE_RIGHTALT;
  _keyw[KEY_LALT]=SCANCODE_LEFTALT;
  _keyw[KEY_SPACE]=SCANCODE_SPACE;
  _keyw[KEY_ENTER]=SCANCODE_ENTER;
  _keyw[KEY_BSP]=SCANCODE_BACKSPACE;
  _keyw[KEY_RCURS]=SCANCODE_CURSORRIGHT;
  _keyw[KEY_LCURS]=SCANCODE_CURSORLEFT;
  _keyw[KEY_UCURS]=SCANCODE_CURSORUP;
  _keyw[KEY_DCURS]=SCANCODE_CURSORDOWN;
  _keyw[KEY_F1]=SCANCODE_F1;
  _keyw[KEY_F2]=SCANCODE_F2;
  _keyw[KEY_F3]=SCANCODE_F3;
  _keyw[KEY_F4]=SCANCODE_F4;
  _keyw[KEY_F5]=SCANCODE_F5;
  _keyw[KEY_F6]=SCANCODE_F6;
  _keyw[KEY_F7]=SCANCODE_F7;
  _keyw[KEY_F8]=SCANCODE_F8;
  _keyw[KEY_F9]=SCANCODE_F9;
  _keyw[KEY_F10]=SCANCODE_F10;
  _keyw[KEY_F11]=SCANCODE_F11;
  _keyw[KEY_F12]=SCANCODE_F12;
} /* Ende _init_keys */


/* +++ functions +++ */

int open_window(const char * wnam,int dp) {
/* initialize screen for graphics
** 1.arg: is not used (NULL)
** 2.arg: is not used (0)
** return: 0=ok or -1=error
**
** To Do:
** all initializing has to be done here:
**  - set screen to graphic mode
**  - load colormap
**  - create backbuffer and set bp_doppl
**  - initialize keyboard and mouse
*/
  pys=NULL;

  /* set to graphic mode */
  vga_init();
  if (!vga_hasmode(G320x200x256)) {strcpy(errmsg,"Can't switch to VGA modus!"); return(-1);}
  vga_setmode(G320x200x256);
  gl_setcontextvga(G320x200x256);
  gl_enableclipping();
  pys=gl_allocatecontext();
  gl_getcontext(pys);

  /* load colormap */
  if (load_colormap(NULL)<0) {vga_setmode(TEXT); return(-1);}
  gl_clearscreen(_rgb_black);

  /* create backbuffer and set bp_doppl */
  bp_doppl=1;
  backpuffer=create_grafik(SC_WIDTH,SC_HEIGHT);
  if (backpuffer==NULL) {strcpy(errmsg,"Can't create backbuffer!"); vga_setmode(TEXT); return(-1);}

  /* initialize keyboard and mouse */
  if (keyboard_init()<0) {strcpy(errmsg,"Can't init keyboard!"); vga_setmode(TEXT); return(-1);}
  keyboard_translatekeys(TRANSLATE_CURSORKEYS|TRANSLATE_KEYPADENTER);
  _init_keys();
  if ((vga_getmousetype()&MOUSE_TYPE_MASK)==MOUSE_NONE) {_no_maus=1;} else {_no_maus=0; vga_setmousesupport(1);}
  _maus_x=_maus_y=-1;
  _maus_left=_maus_right=_maus_middle=0;
  if (!_no_maus) {
    mouse_setwrap(MOUSE_NOWRAP);
    mouse_speed(2);
  }
  clearstate();

  return(0);
} /* Ende open_window */


void flush_window() {
/* give backbuffer out to screen */
  memmove(pys->vbuf,backpuffer->pxm,SC_WIDTH*SC_HEIGHT);
} /* Ende flush_window */


void close_window() {
/* To Do:
** close graphic screen,
** reset keyboard,
** make text screen
*/
  free_grafik(backpuffer);
  if (pys!=NULL) {gl_freecontext(pys);}
  keyboard_close();
  vga_setmode(TEXT);
} /* Ende close_window */


int reopen_window(int dp) {
/* reopen screen with another size: unused here */
  return(0);
} /* Ende reopen_window */


void get_keys() {
/* get pressed or released keys and mouse position and buttons
** To Do:
** test each key added with ADD_KEYS() whether pressed or not,
** regarding SHORT_KEY or LONG_KEY and set _keyc[key-index] to 1=yes or else=no,
** set _maus_x and _maus_y to mouse coordinates,
** set _maus_left, _maus_middle, _maus_right to 1=pressed or else=not pressed
*/
  int i1,i2;

  /* for each key added with ADD_KEYS(): _keyi is index */
  for (i1=0;i1<_keyi;i1++) {
    /* if SHORT_KEY and pressed then set it unpressed */
    if ((_keym[i1]&8192)==0) {  /* 8192 is LONG_KEY */
      i2=_keym[i1]&~8192;
      if (_keyc[i2]==1) {_keyc[i2]=2;}
    }
  }

  keyboard_update();  /* get keyboard input */
  /* for each key added with ADD_KEYS(): _keyi is index */
  for (i1=0;i1<_keyi;i1++) {
    i2=_keym[i1]&~8192;  /* 8192 is LONG_KEY */
    if (_keyc[i2]>=2) {
      /* test only for releasing key */
      if (keyboard_keypressed(_keyw[i2])==KEY_NOTPRESSED) {_keyc[i2]=0;}
    } else {
      /* test for pressing or releasing key */
      if (keyboard_keypressed(_keyw[i2])==KEY_PRESSED) {_keyc[i2]=1;} else {_keyc[i2]=0;}
    }
  }

  if (!_no_maus) {  /* mouse found */
    static int bzx=0,bzy=0;
    mouse_update();  /* get mouse events */
    i1=mouse_getbutton();  /* check whether button pressed */
    _maus_x=mouse_getx()-bzx;  /* set x position of mouse */
    if (_maus_x>SC_WIDTH) {bzx+=_maus_x-SC_WIDTH; _maus_x=SC_WIDTH;}
    else if (_maus_x<0) {bzx+=_maus_x; _maus_x=0;}
    _maus_y=mouse_gety()-bzy;  /* set y position of mouse */
    if (_maus_y>SC_HEIGHT) {bzy+=_maus_y-SC_HEIGHT; _maus_y=SC_HEIGHT;}
    else if (_maus_y<0) {bzy+=_maus_y; _maus_y=0;}
    if (i1&MOUSE_LEFTBUTTON) {  /* left button pressed */
      /* if it was pressed before, set it to 2, which also means: not pressed */
      if (_maus_left==0) {_maus_left=1;} else {_maus_left=2;}
    } else {_maus_left=0;}
    if (i1&MOUSE_MIDDLEBUTTON) {  /* middle button pressed */
      /* if it was pressed before, set it to 2, which also means: not pressed */
      if (_maus_middle==0) {_maus_middle=1;} else {_maus_middle=2;}
    } else {_maus_middle=0;}
    if (i1&MOUSE_RIGHTBUTTON) {  /* right button pressed */
      /* if it was pressed before, set it to 2, which also means: not pressed */
      if (_maus_right==0) {_maus_right=1;} else {_maus_right=2;}
    } else {_maus_right=0;}
  }
} /* Ende get_keys */


void clearstate() {
/* flush all keyboard (and mouse) events and set _keyc[] to 3 */
  int i1;
  keyboard_clearstate();
  for (i1=0;i1<KEYS_INDEX;i1++) {_keyc[i1]=3;}
  _maus_left=_maus_middle=_maus_right=2;
} /* Ende clearstate */


int mouse_speed(int index) {
/* speed of mouse, from 1=slow to 3=fast; returns previous speed index */
  static int mvs=1;
  int vs;
  if (index<1) {index=1;} else if (index>3) {index=3;}
  mouse_setscale(index==1?120:(index==2?70:50));
  vs=mvs;
  mvs=index;
  return(vs);
} /* Ende mouse_speed */


void brightness(int vol) {
/* reduces or increases brightness of colormap
** 1.arg: -63 (darkest) to 62 (lightest), 0 is default, or 99=last brightness
**
** To Do:
** set all colors of loaded colormap according to brightness
*/
  static int lastvol=0;
  int r,g,b;
  int i1,i2,i3;
  float f1;
  if (vol==99) {vol=lastvol;}
  else if (vol<-63) {vol=-63;}
  else if (vol>62) {vol=62;}
  lastvol=vol;
  for (i1=0;i1<256;i1++) {  /* fx: color map of e.g. RGB256_FILE */
    i3=vol;
    r=fx[i1].r;
    g=fx[i1].g;
    b=fx[i1].b;
    i2=(r>g?(r>b?r:b):(g>b?g:b));  /* get highest value */
    if (i2>0) {
      if (i2+i3>63) {i3=63-i2;}
      f1=(float)i3/(float)i2;
      r+=(f1*r);
      g+=(f1*g);
      b+=(f1*b);
      if (r<0) {r=0;} else if (r>63) {r=63;}
      if (g<0) {g=0;} else if (g>63) {g=63;}
      if (b<0) {b=0;} else if (b>63) {b=63;}
    }
    gl_setpalettecolor(i1,r,g,b);
  }
} /* Ende brightness */
