/* *****************************************************************
   Include-file for "vgagames.c": for graphic library "libvgl".
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <signal.h>


/* +++ declarations +++ */

int _no_maus;

static int bp_doppl;
static int _keyw[KEYS_INDEX];
static void _init_keys(void);
static int _mouse_signal=SIGUSR2;


/* +++ internal functions +++ */

static void _init_keys() {
/* initalize keys, called from open_window()
** To Do:
** set _keyw[] to scancodes to compare it in get_keys() when pressed
*/
  _keyw[KEY_0]=11;
  _keyw[KEY_1]=2;
  _keyw[KEY_2]=3;
  _keyw[KEY_3]=4;
  _keyw[KEY_4]=5;
  _keyw[KEY_5]=6;
  _keyw[KEY_6]=7;
  _keyw[KEY_7]=8;
  _keyw[KEY_8]=9;
  _keyw[KEY_9]=10;
  _keyw[KEY_A]=30;
  _keyw[KEY_B]=48;
  _keyw[KEY_C]=46;
  _keyw[KEY_D]=32;
  _keyw[KEY_E]=18;
  _keyw[KEY_F]=33;
  _keyw[KEY_G]=34;
  _keyw[KEY_H]=35;
  _keyw[KEY_I]=23;
  _keyw[KEY_J]=36;
  _keyw[KEY_K]=37;
  _keyw[KEY_L]=38;
  _keyw[KEY_M]=50;
  _keyw[KEY_N]=49;
  _keyw[KEY_O]=24;
  _keyw[KEY_P]=25;
  _keyw[KEY_Q]=16;
  _keyw[KEY_R]=19;
  _keyw[KEY_S]=31;
  _keyw[KEY_T]=20;
  _keyw[KEY_U]=22;
  _keyw[KEY_V]=47;
  _keyw[KEY_W]=17;
  _keyw[KEY_X]=45;
  _keyw[KEY_Y]=44;
  _keyw[KEY_Z]=21;
  _keyw[KEY_KP_0]=82;
  _keyw[KEY_KP_1]=79;
  _keyw[KEY_KP_2]=80;
  _keyw[KEY_KP_3]=81;
  _keyw[KEY_KP_4]=75;
  _keyw[KEY_KP_5]=76;
  _keyw[KEY_KP_6]=77;
  _keyw[KEY_KP_7]=71;
  _keyw[KEY_KP_8]=72;
  _keyw[KEY_KP_9]=73;
  _keyw[KEY_ESC]=1;
  _keyw[KEY_TAB]=15;
  _keyw[KEY_RSHIFT]=54;
  _keyw[KEY_LSHIFT]=42;
  _keyw[KEY_RCTRL]=90;
  _keyw[KEY_LCTRL]=29;
  _keyw[KEY_RALT]=93;
  _keyw[KEY_LALT]=56;
  _keyw[KEY_SPACE]=57;
  _keyw[KEY_ENTER]=28;
  _keyw[KEY_BSP]=14;
  _keyw[KEY_RCURS]=98;
  _keyw[KEY_LCURS]=97;
  _keyw[KEY_UCURS]=95;
  _keyw[KEY_DCURS]=100;
  _keyw[KEY_F1]=59;
  _keyw[KEY_F2]=60;
  _keyw[KEY_F3]=61;
  _keyw[KEY_F4]=62;
  _keyw[KEY_F5]=63;
  _keyw[KEY_F6]=64;
  _keyw[KEY_F7]=65;
  _keyw[KEY_F8]=66;
  _keyw[KEY_F9]=67;
  _keyw[KEY_F10]=68;
  _keyw[KEY_F11]=87;
  _keyw[KEY_F12]=88;
} /* Ende _init_keys */


/* +++ functions +++ */

int open_window(const char * wnam,int dp) {
/* initialize screen for graphics
** 1.arg: is not used (NULL)
** 2.arg: is not used (0)
** return: 0=ok or -1=error
**
** To Do:
** all initializing has to be done here:
**  - set screen to graphic mode
**  - load colormap
**  - create backbuffer and set bp_doppl
**  - initialize keyboard and mouse
*/
  /* set to graphic mode */
  VGLInit(SW_VGA_CG320);
  if (VGLDisplay->Type!=VIDBUF8) {strcpy(errmsg,"Wrong video mode!"); VGLEnd(); return(-1);}

  /* load colormap */
  if (load_colormap(NULL)<0) {VGLEnd(); return(-1);}
  VGLClear(VGLDisplay,_rgb_black);
  VGLSetBorder(_rgb_black);

  /* create backbuffer and set bp_doppl */
  bp_doppl=1;
  backpuffer=create_grafik(SC_WIDTH,SC_HEIGHT);
  if (backpuffer==NULL) {strcpy(errmsg,"Can't create backbuffer!"); VGLEnd(); return(-1);}

  /* initialize keyboard and mouse */
  if (VGLKeyboardInit(VGL_CODEKEYS)<0) {strcpy(errmsg,"Can't init keyboard!"); VGLEnd(); return(-1);}
  _init_keys();
  if (VGLMouseInit(VGL_MOUSEHIDE)<0) {_no_maus=1;} else {_no_maus=0;}
  _maus_x=_maus_y=-1;
  _maus_left=_maus_right=_maus_middle=0;
  if (!_no_maus) {
    mouse_info_t mi;
    mi.operation=MOUSE_MODE;
    mi.u.mode.signal=0;
    ioctl(0,CONS_MOUSECTL,&mi);  /* don't want to be interrupted by signal */
    signal(_mouse_signal,SIG_IGN);
    mouse_speed(2);
  }
  clearstate();

  return(0);
} /* Ende open_window */


void flush_window() {
/* give backbuffer out to screen */
  memmove(VGLDisplay->Bitmap,backpuffer->pxm,SC_WIDTH*SC_HEIGHT);
} /* Ende flush_window */


void close_window() {
/* To Do:
** close graphic screen,
** reset keyboard,
** make text screen
*/
  free_grafik(backpuffer);
  VGLKeyboardEnd();
  VGLEnd();
} /* Ende close_window */


int reopen_window(int dp) {
/* reopen screen with another size: unused here */
  return(0);
} /* Ende reopen_window */


void get_keys() {
/* get pressed or released keys and mouse position and buttons
** To Do:
** test each key added with ADD_KEYS() whether pressed or not,
** regarding SHORT_KEY or LONG_KEY and set _keyc[key-index] to 1=yes or else=no,
** set _maus_x and _maus_y to mouse coordinates,
** set _maus_left, _maus_middle, _maus_right to 1=pressed or else=not pressed
*/
  int i1,i2,kchar,pressed;

  /* for each key added with ADD_KEYS(): _keyi is index */
  for (i1=0;i1<_keyi;i1++) {
    /* if SHORT_KEY and pressed then set it unpressed */
    if ((_keym[i1]&8192)==0) {  /* 8192 is LONG_KEY */
      i2=_keym[i1]&~8192;
      if (_keyc[i2]==1) {_keyc[i2]=2;}
    }
  }

  while ((kchar=VGLKeyboardGetCh())!=0) {  /* get all keyboard input */
    if (kchar>=128) {kchar-=128; pressed=0;} else {pressed=1;}
    /* for each key added with ADD_KEYS(): _keyi is index */
    for (i1=0;i1<_keyi;i1++) {
      i2=_keym[i1]&~8192;  /* 8192 is LONG_KEY */
      if (kchar==_keyw[i2]) {  /* if actual key */
        if (_keyc[i2]>=2) {
          /* test only for releasing key */
          if (!pressed) {_keyc[i2]=0;}
        } else {
          /* test for pressing or releasing key */
          if (pressed) {_keyc[i2]=1;} else {_keyc[i2]=0;}
        }
      }
    }
  }
  for (i1=0;i1<_keyi;i1++) {
    i2=_keym[i1]&~8192;
    if (_keyc[i2]==3) {_keyc[i2]=0;}
  }

  if (!_no_maus) {  /* mouse found */
#define MOUSE_LEFTBUTTON   1
#define MOUSE_MIDDLEBUTTON 2
#define MOUSE_RIGHTBUTTON  4
    static int bzx=0,bzy=0;
    mouse_info_t mi;
    mi.operation=MOUSE_GETINFO;
    ioctl(0,CONS_MOUSECTL,&mi);  /* get mouse events */
    i1=mi.u.data.buttons;  /* get pressed buttons */
    _maus_x=mi.u.data.x-bzx;  /* set x position of mouse */
    if (_maus_x>SC_WIDTH) {bzx+=_maus_x-SC_WIDTH; _maus_x=SC_WIDTH;}
    else if (_maus_x<0) {bzx+=_maus_x; _maus_x=0;}
    _maus_y=mi.u.data.y-bzy;  /* set y position of mouse */
    if (_maus_y>SC_HEIGHT) {bzy+=_maus_y-SC_HEIGHT; _maus_y=SC_HEIGHT;}
    else if (_maus_y<0) {bzy+=_maus_y; _maus_y=0;}
    if (i1&MOUSE_LEFTBUTTON) {  /* left button pressed */
      /* if it was pressed before, set it to 2, which also means: not pressed */
      if (_maus_left==0) {_maus_left=1;} else {_maus_left=2;}
    } else {_maus_left=0;}
    if (i1&MOUSE_MIDDLEBUTTON) {  /* middle button pressed */
      /* if it was pressed before, set it to 2, which also means: not pressed */
      if (_maus_middle==0) {_maus_middle=1;} else {_maus_middle=2;}
    } else {_maus_middle=0;}
    if (i1&MOUSE_RIGHTBUTTON) {  /* right button pressed */
      /* if it was pressed before, set it to 2, which also means: not pressed */
      if (_maus_right==0) {_maus_right=1;} else {_maus_right=2;}
    } else {_maus_right=0;}
  }
} /* Ende get_keys */


void clearstate() {
/* flush all keyboard (and mouse) events and set _keyc[] to 3 */
  int i1;
  while (VGLKeyboardGetCh()!=0) {;}
  for (i1=0;i1<KEYS_INDEX;i1++) {_keyc[i1]=3;}
  _maus_left=_maus_middle=_maus_right=2;
} /* Ende clearstate */


int mouse_speed(int index) {
/* speed of mouse can't be changed; returns 0 */
  if (index<1) {index=1;} else if (index>3) {index=3;}
  return(0);
} /* Ende mouse_speed */


void brightness(int vol) {
/* reduces or increases brightness of colormap
** (all graphics should be drawn again to take effect of it)
** 1.arg: -63 (darkest) to 62 (lightest), 0 is default, or 99=last brightness
**
** To Do:
** set all colors of loaded colormap according to brightness
*/
  static int lastvol=0;
  int r,g,b;
  int i1,i2,i3;
  float f1;
  if (vol==99) {vol=lastvol;}
  else if (vol<-63) {vol=-63;}
  else if (vol>62) {vol=62;}
  lastvol=vol;
  for (i1=0;i1<256;i1++) {  /* fx: color map of e.g. RGB256_FILE */
    i3=vol;
    r=fx[i1].r;
    g=fx[i1].g;
    b=fx[i1].b;
    i2=(r>g?(r>b?r:b):(g>b?g:b));  /* get highest value */
    if (i2>0) {
      if (i2+i3>63) {i3=63-i2;}
      f1=(float)i3/(float)i2;
      r+=(f1*r);
      g+=(f1*g);
      b+=(f1*b);
      if (r<0) {r=0;} else if (r>63) {r=63;}
      if (g<0) {g=0;} else if (g>63) {g=63;}
      if (b<0) {b=0;} else if (b>63) {b=63;}
    }
    VGLSetPaletteIndex(i1,r,g,b);
  }
} /* Ende brightness */
