/* *****************************************************************
   Include-file for "vgagames.c": for graphic library "X window".
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

#include <signal.h>


/* +++ declarations +++ */

#ifdef GRLIB_X_EXTS
  #define POSX  (fullscr?((WidthOfScreen(DefaultScreenOfDisplay(display))-rww)/2):0)
  #define POSY  (fullscr?((HeightOfScreen(DefaultScreenOfDisplay(display))-rwh)/2):0)
#else
  #define POSX  0
  #define POSY  0
#endif

static int cl_exit=-1;
static int bp_doppl,rww,rwh,noswitch;
static char _keyw[KEYS_INDEX][20];
static unsigned int _maus_leftbutton,_maus_middlebutton,_maus_rightbutton;
static int zx,zy;
static Display * display;
static int screen;
#ifdef GRLIB_X_EXTS
  static int virtwidth=640, virtheight=480;
  static XF86VidModeModeInfo mi_res;
#endif
static unsigned int cdepth;
static unsigned long px_black,px_white;
static Window window;
static Colormap colormap;
unsigned long colpix[256];
static GC gc_farbe[2];
static int fullscr=0;
static int colfirst=1;
static XVisualInfo * xvi=NULL;
static void _init_keys(void);
static GC _create_gc(Drawable,unsigned long);
static void _restore_mode(void);
void do_sig(int);


/* +++ internal functions +++ */

static void _init_keys() {
/* initalize keys, called from open_window() */
  strcpy(_keyw[KEY_0],"0");
  strcpy(_keyw[KEY_1],"1");
  strcpy(_keyw[KEY_2],"2");
  strcpy(_keyw[KEY_3],"3");
  strcpy(_keyw[KEY_4],"4");
  strcpy(_keyw[KEY_5],"5");
  strcpy(_keyw[KEY_6],"6");
  strcpy(_keyw[KEY_7],"7");
  strcpy(_keyw[KEY_8],"8");
  strcpy(_keyw[KEY_9],"9");
  strcpy(_keyw[KEY_A],"A");
  strcpy(_keyw[KEY_B],"B");
  strcpy(_keyw[KEY_C],"C");
  strcpy(_keyw[KEY_D],"D");
  strcpy(_keyw[KEY_E],"E");
  strcpy(_keyw[KEY_F],"F");
  strcpy(_keyw[KEY_G],"G");
  strcpy(_keyw[KEY_H],"H");
  strcpy(_keyw[KEY_I],"I");
  strcpy(_keyw[KEY_J],"J");
  strcpy(_keyw[KEY_K],"K");
  strcpy(_keyw[KEY_L],"L");
  strcpy(_keyw[KEY_M],"M");
  strcpy(_keyw[KEY_N],"N");
  strcpy(_keyw[KEY_O],"O");
  strcpy(_keyw[KEY_P],"P");
  strcpy(_keyw[KEY_Q],"Q");
  strcpy(_keyw[KEY_R],"R");
  strcpy(_keyw[KEY_S],"S");
  strcpy(_keyw[KEY_T],"T");
  strcpy(_keyw[KEY_U],"U");
  strcpy(_keyw[KEY_V],"V");
  strcpy(_keyw[KEY_W],"W");
  strcpy(_keyw[KEY_X],"X");
  strcpy(_keyw[KEY_Y],"Y");
  strcpy(_keyw[KEY_Z],"Z");
  strcpy(_keyw[KEY_KP_0],"KP_0");
  strcpy(_keyw[KEY_KP_1],"KP_1");
  strcpy(_keyw[KEY_KP_2],"KP_2");
  strcpy(_keyw[KEY_KP_3],"KP_3");
  strcpy(_keyw[KEY_KP_4],"KP_4");
  strcpy(_keyw[KEY_KP_5],"KP_5");
  strcpy(_keyw[KEY_KP_6],"KP_6");
  strcpy(_keyw[KEY_KP_7],"KP_7");
  strcpy(_keyw[KEY_KP_8],"KP_8");
  strcpy(_keyw[KEY_KP_9],"KP_9");
  strcpy(_keyw[KEY_ESC],"ESCAPE");
  strcpy(_keyw[KEY_TAB],"TAB");
  strcpy(_keyw[KEY_RSHIFT],"SHIFT_R");
  strcpy(_keyw[KEY_LSHIFT],"SHIFT_L");
  strcpy(_keyw[KEY_RCTRL],"CONTROL_R");
  strcpy(_keyw[KEY_LCTRL],"CONTROL_L");
  strcpy(_keyw[KEY_RALT],"ALT_R");
  strcpy(_keyw[KEY_LALT],"ALT_L");
  strcpy(_keyw[KEY_SPACE],"SPACE");
  strcpy(_keyw[KEY_ENTER],"RETURN");
  strcpy(_keyw[KEY_BSP],"BACKSPACE");
  strcpy(_keyw[KEY_RCURS],"RIGHT");
  strcpy(_keyw[KEY_LCURS],"LEFT");
  strcpy(_keyw[KEY_UCURS],"UP");
  strcpy(_keyw[KEY_DCURS],"DOWN");
  strcpy(_keyw[KEY_F1],"F1");
  strcpy(_keyw[KEY_F2],"F2");
  strcpy(_keyw[KEY_F3],"F3");
  strcpy(_keyw[KEY_F4],"F4");
  strcpy(_keyw[KEY_F5],"F5");
  strcpy(_keyw[KEY_F6],"F6");
  strcpy(_keyw[KEY_F7],"F7");
  strcpy(_keyw[KEY_F8],"F8");
  strcpy(_keyw[KEY_F9],"F9");
  strcpy(_keyw[KEY_F10],"F10");
  strcpy(_keyw[KEY_F11],"F11");
  strcpy(_keyw[KEY_F12],"F12");
} /* Ende _init_keys */


static GC _create_gc(Drawable wd,unsigned long vf) {
  XGCValues xgcv;
  xgcv.foreground=vf;
  xgcv.background=px_black;
  return(XCreateGC(display,wd,GCForeground|GCBackground,&xgcv));
} /* Ende _create_gc */


static void _restore_mode() {
  if (cl_exit<1) {return;}
#ifdef GRLIB_X_EXTS
  if (noswitch==0) {
    XF86VidModeSwitchToMode(display,screen,&mi_res);
    XF86VidModeSetViewPort(display,screen,0,0);
    XFlush(display);
    XSync(display,False);
  }
#endif
} /* Ende _restore_mode */


/* +++ functions +++ */

void do_sig(int signum) {
  char buf[128];
  _restore_mode(); 
  strcpy(buf,"--> caught signal 000\n");
  buf[18]=(signum/100)%10+48;
  buf[19]=(signum/10)%10+48;
  buf[20]=signum%10+48;
  write(STDERR_FILENO,buf,strlen(buf));
  _exit(1);
} /* Ende do_sig */


int open_window(const char * wnam,int dp) {
/* create window
** 1.arg: name of the window (NULL=same name as before)
** 2.arg: scaling factor
**        0:              get largest window size, no full screen
**        VGAWINDOW_1:    window scaling factor 1  (original size)
**        VGAWINDOW_2:    window scaling factor 2  (4 pixels per pixel)
**        VGAWINDOW_3:    window scaling factor 3  (9 pixels per pixel)
**        VGAWINDOW_FULL: full screen modus
**        VGAWINDOW_NOSWITCH: don't switch to another mode
** return: 0=ok or -1=error
*/
  static char * pnam=NULL;
  Window rootw;
  XSetWindowAttributes attributes;
  unsigned long attr_mask;
  int bs_w,bs_h;
  struct sigaction sa;

  if (cl_exit==-1) {
    memset(&sa,0,sizeof(sa));
    sa.sa_handler=do_sig;
    sigaction(SIGSEGV,&sa,NULL);
    sigaction(SIGBUS,&sa,NULL);
    sigaction(SIGINT,&sa,NULL);
    sigaction(SIGTERM,&sa,NULL);
    atexit(_restore_mode);
    cl_exit=0;
  }
  if (wnam==NULL) {
    if (pnam==NULL) {pnam=strdup("vgagames");}
  } else {
    if (pnam!=NULL) {free(pnam);}
    pnam=strdup(wnam);
  }
  if (dp>=VGAWINDOW_NOSWITCH) {
    dp-=VGAWINDOW_NOSWITCH;
    noswitch=1;
  } else {noswitch=0;}

  /* connection to X */
  if ((display=XOpenDisplay(":0.0"))==NULL) {strcpy(errmsg,"Can't connect to :0.0!"); return(-1);}

  /* get DefaultScreen number */
  screen=DefaultScreen(display);

  /* get RootWindow of screen */
  rootw=RootWindow(display,screen);

#ifdef GRLIB_X_EXTS
  if (noswitch==0) {
    XF86VidModeModeInfo ** mi;
    XF86VidModeModeLine ml;
    void * vpt;
    int mc,i1,mw;
    int width=WidthOfScreen(DefaultScreenOfDisplay(display));
    int height=HeightOfScreen(DefaultScreenOfDisplay(display));
    virtwidth=640; virtheight=480;
    memset(&mi_res,0,sizeof(mi_res));
    XF86VidModeGetModeLine(display,screen,&mc,&ml);
    vpt=&mi_res;
    mi_res.dotclock=mc;
    memmove(vpt+sizeof(unsigned int),&ml,sizeof(ml));
    XF86VidModeGetAllModeLines(display,screen,&mc,&mi);
    printf("Modes found: ");
    mw=-1;
    for (i1=0;i1<mc;i1++) {
      printf("%dx%d ",mi[i1]->hdisplay,mi[i1]->vdisplay);
#if 0
      if ((mi[i1]->hdisplay==virtwidth) && (mi[i1]->vdisplay==virtheight)) {
        width=mi[i1]->hdisplay; height=mi[i1]->vdisplay;
        mw=i1;
        break;
      } else
#endif
      if ((mi[i1]->hdisplay<=width) && (mi[i1]->vdisplay<=height) \
      && (mi[i1]->hdisplay>=SC_WIDTH) && (mi[i1]->vdisplay>=SC_HEIGHT)) {
        width=mi[i1]->hdisplay; height=mi[i1]->vdisplay;
        mw=i1;
      }
    }
    if (mw>=0) {
      printf("\nSwitching to %dx%d",mi[mw]->hdisplay,mi[mw]->vdisplay);
      XF86VidModeSwitchToMode(display,screen,mi[mw]);
      XF86VidModeSetViewPort(display,screen,0,0);
      XWarpPointer(display,None,None,0,0,0,0,-10000,-10000);
      XFlush(display);
      XSync(display,False);
    }
    virtwidth=width; virtheight=height;
    printf("\n");
  } else {printf("No switching to another mode\n");}
#else
  noswitch=1;
#endif

  /* get default bit number of RootWindow of DefaultScreen */
  cdepth=DefaultDepthOfScreen(DefaultScreenOfDisplay(display));
  bs_w=WidthOfScreen(DefaultScreenOfDisplay(display));
  bs_h=HeightOfScreen(DefaultScreenOfDisplay(display));
#ifdef GRLIB_X_EXTS
  if (noswitch) {virtwidth=bs_w; virtheight=bs_h;}
#endif
  zx=bs_w; zy=bs_h;
  bs_w/=SC_WIDTH;
  bs_h/=SC_HEIGHT;
  bp_doppl=(bs_w<bs_h?bs_w:bs_h);
  if (dp>=VGAWINDOW_FULL) {
    dp-=VGAWINDOW_FULL;
    fullscr=1;
  } else {fullscr=0;}
  if ((bp_doppl>=1) && (dp==VGAWINDOW_1)) {bp_doppl=1;}
  else if ((bp_doppl>=2) && (dp==VGAWINDOW_2)) {bp_doppl=2;}
  else if ((bp_doppl>=3) && (dp==VGAWINDOW_3)) {bp_doppl=3;}
  if (bp_doppl>3) {bp_doppl=3;}
#ifdef GRLIB_X_EXTS
  while (bp_doppl>1) {
    if ((SC_WIDTH*bp_doppl>virtwidth) || (SC_HEIGHT*bp_doppl>virtheight)) {
      bp_doppl--;
    } else {break;}
  }
#endif
  if (fullscr) {
    rww=zx; rwh=zy;
    zx-=SC_WIDTH*bp_doppl;
    zx/=2;
    zy-=SC_HEIGHT*bp_doppl;
    zy/=2;
  } else {
    zx=zy=0;
    rww=SC_WIDTH*bp_doppl; rwh=SC_HEIGHT*bp_doppl;
  }
#ifdef GRLIB_X_EXTS
  if (fullscr) {
    XWarpPointer(display,None,None,0,0,0,0,-10000,-10000);
    XWarpPointer(display,None,None,0,0,0,0,(WidthOfScreen(DefaultScreenOfDisplay(display))+virtwidth)/2,(HeightOfScreen(DefaultScreenOfDisplay(display))+virtheight)/2);
    XWarpPointer(display,None,None,0,0,0,0,-virtwidth/2,-virtheight/2);
    XFlush(display);
    XSync(display,False);
  } else {
    XWarpPointer(display,None,None,0,0,0,0,-10000,-10000);
    XWarpPointer(display,None,None,0,0,0,0,SC_WIDTH*bp_doppl/2,SC_HEIGHT*bp_doppl/2);
    XFlush(display);
    XSync(display,False);
  }
#endif

#if 0
  {XFontStruct * font;
   int fh;
   /* load font */
   font=XLoadQueryFont(display,"variable");
   if (font==NULL) {
     font=XLoadQueryFont(display,"fixed");
   }
   fh=font->ascent+font->descent;  /* Font Height */
  }
#endif

  /* get Black/White pixel value of screen number */
  px_black=BlackPixel(display,screen);
  px_white=WhitePixel(display,screen);

  /* set default colormap */
  colormap=DefaultColormap(display,screen);

  /* get a PseudoColor visual or not */
  {XVisualInfo xvt;
   int vn;
#if defined(__cplusplus) || defined(c_plusplus)
   xvt.c_class=PseudoColor;
#else
   xvt.class=PseudoColor;
#endif
   xvt.screen=screen;
   xvt.depth=cdepth;
   xvi=XGetVisualInfo(display,VisualScreenMask|VisualDepthMask|VisualClassMask,&xvt,&vn);
   if (vn==0) {
     if (xvi!=NULL) {XFree(xvi); xvi=NULL;}
   }
  }

  /* open window */
  if (fullscr) {attributes.override_redirect=True;}
  attributes.background_pixel=px_black;  /* background color */
  attributes.border_pixel=px_white;  /* foreground color */
  attributes.event_mask=KeyPressMask|KeyReleaseMask;
  attributes.event_mask|=ButtonPressMask|ButtonReleaseMask|PointerMotionMask;
  attributes.event_mask|=LeaveWindowMask|EnterWindowMask;
  attr_mask=CWEventMask|CWBackPixel|CWBorderPixel;
  if (fullscr) {attr_mask|=CWOverrideRedirect;}
  window=XCreateWindow(display,rootw,POSX,POSY,rww,rwh,0,CopyFromParent,InputOutput,(Visual *)CopyFromParent,attr_mask,&attributes);

  /* set mouse buttons */
  _maus_x=_maus_y=-1;
  _maus_left=_maus_right=_maus_middle=0;
#ifdef GRLIB_X_EXTS
  _maus_x=SC_WIDTH/2;
  _maus_y=SC_HEIGHT/2;
#endif
  {unsigned char mapr[3],nmap;
   int erg;
   nmap=3;
   erg=XGetPointerMapping(display,mapr,nmap);
   _maus_leftbutton=_maus_middlebutton=_maus_rightbutton=0;
   if (erg>0) {_maus_leftbutton=mapr[0];}
   if (erg>1) {_maus_middlebutton=mapr[1];}
   if (erg>2) {_maus_rightbutton=mapr[2];}
  }

  /* set window hints */
  {XSizeHints sh;
   XClassHint ch;
   XWMHints wh;
   sh.x=POSX;
   sh.y=POSY;
   sh.height=rwh;
   sh.width=rww;
   sh.min_height=rwh;
   sh.min_width=rww;
   sh.base_height=rwh;
   sh.base_width=rww;
   sh.flags=USPosition|USSize|PMinSize|PBaseSize;
   XSetWMNormalHints(display,window,&sh);
   XStoreName(display,window,pnam);
   ch.res_class=pnam;
   ch.res_name=pnam;
   XSetClassHint(display,window,&ch);
   wh.initial_state=NormalState;
   wh.input=True;
   wh.flags=InputHint|StateHint;
   XSetWMHints(display,window,&wh);
  }

  /* show window */
  XMapRaised(display,window);
  XFlush(display);

  /* load colormap and set 256 GCs for all 256 colors
  ** Indexes with RGB-values are read from file RGB256_FILE
  */
  colfirst=1;  /* first call of brightness() */
  if (xvi!=NULL) {  /* create a colormap */
    colormap=XCreateColormap(display,window,xvi->visual,AllocAll);
  }
  if (load_colormap(NULL)<0) {return(-1);}
  colfirst=0;

  /* create backbuffer */
  backpuffer=create_grafik(SC_WIDTH,SC_HEIGHT);
  if (backpuffer==NULL) {strcpy(errmsg,"Can't create backbuffer!"); return(-1);}
  XFillRectangle(display,window,gc_farbe[0],0,0,rww,rwh);

  /* set cursor */
  {Pixmap pixcurs;
   XColor xc;
   GC gc0;
   Cursor curs;
   xc.red=0; xc.green=0; xc.blue=0;
   xc.flags=DoRed|DoGreen|DoBlue;
   pixcurs=XCreatePixmap(display,window,1,1,1);
   gc0=_create_gc(pixcurs,0);
   XDrawPoint(display,pixcurs,gc0,0,0);
   curs=XCreatePixmapCursor(display,pixcurs,pixcurs,&xc,&xc,0,0);
   XDefineCursor(display,window,curs);
  }

  /* set keys for keyboard */
  _init_keys();
  clearstate();

  /* get an async grab on keyboard and pointer */
  if (fullscr) {
    XGrabKeyboard(display,window,True,GrabModeAsync,GrabModeAsync,CurrentTime);
    XGrabPointer(display,window,True,ButtonPressMask|ButtonReleaseMask|PointerMotionMask|LeaveWindowMask,GrabModeAsync,GrabModeAsync,None,None,CurrentTime);
  }

  sleep(1);
  cl_exit=1;
  return(0);
} /* Ende open_window */


void flush_window() {
/* give backbuffer out to screen */
  int i1,i2,i3,i4;
  unsigned char * sptr,* dptr;
  static XImage * xim=NULL;
  if (xim==NULL) {
    xim=XGetImage(display,window,zx,zy,SC_WIDTH*bp_doppl,SC_HEIGHT*bp_doppl,0xffffffff,ZPixmap);
  }

  if (xim->bits_per_pixel==8) {
    switch(bp_doppl) {
      case 1:
        for (i1=0;i1<SC_HEIGHT;i1++) {
          sptr=backpuffer->pxm+i1*SC_WIDTH;
          dptr=(unsigned char *)xim->data+i1*xim->bytes_per_line;
          for (i2=0;i2<SC_WIDTH;i2++) {
            *dptr=colpix[*sptr];
            dptr++;
            sptr++;
          }
        }
        break;
      case 2:
        for (i1=0;i1<SC_HEIGHT;i1++) {
          sptr=backpuffer->pxm+i1*SC_WIDTH;
          dptr=(unsigned char *)xim->data+i1*xim->bytes_per_line*bp_doppl;
          for (i2=0;i2<SC_WIDTH;i2++) {
            *dptr=colpix[*sptr];
            *(dptr+xim->bytes_per_line)=colpix[*sptr];
            dptr++;
            *dptr=colpix[*sptr];
            *(dptr+xim->bytes_per_line)=colpix[*sptr];
            dptr++;
            sptr++;
          }
        }
        break;
      case 3:
        for (i1=0;i1<SC_HEIGHT;i1++) {
          sptr=backpuffer->pxm+i1*SC_WIDTH;
          dptr=(unsigned char *)xim->data+i1*xim->bytes_per_line*bp_doppl;
          for (i2=0;i2<SC_WIDTH;i2++) {
            *dptr=colpix[*sptr];
            *(dptr+xim->bytes_per_line)=colpix[*sptr];
            *(dptr+xim->bytes_per_line*2)=colpix[*sptr];
            dptr++;
            *dptr=colpix[*sptr];
            *(dptr+xim->bytes_per_line)=colpix[*sptr];
            *(dptr+xim->bytes_per_line*2)=colpix[*sptr];
            dptr++;
            *dptr=colpix[*sptr];
            *(dptr+xim->bytes_per_line)=colpix[*sptr];
            *(dptr+xim->bytes_per_line*2)=colpix[*sptr];
            dptr++;
            sptr++;
          }
        }
        break;
      default:
        for (i1=0;i1<SC_HEIGHT;i1++) {
          sptr=backpuffer->pxm+i1*SC_WIDTH;
          dptr=(unsigned char *)xim->data+i1*xim->bytes_per_line*bp_doppl;
          for (i2=0;i2<SC_WIDTH;i2++) {
            for (i3=0;i3<bp_doppl;i3++) {
              for (i4=0;i4<bp_doppl;i4++) {
                *(dptr+xim->bytes_per_line*i4)=colpix[*sptr];
              }
              dptr++;
            }
            sptr++;
          }
        }
    }
  } else {
    for (i1=0;i1<SC_HEIGHT;i1++) {
      sptr=backpuffer->pxm+i1*SC_WIDTH;
      for (i2=0;i2<SC_WIDTH;i2++) {
        for (i3=0;i3<bp_doppl;i3++) {
          for (i4=0;i4<bp_doppl;i4++) {
            XPutPixel(xim,i2*bp_doppl+i4,i1*bp_doppl+i3,colpix[*sptr]);
          }
        }
        sptr++;
      }
    }
  }

  XPutImage(display,window,gc_farbe[1],xim,0,0,zx,zy,SC_WIDTH*bp_doppl,SC_HEIGHT*bp_doppl);
  XFlush(display);
} /* Ende flush_window */


void close_window() {
/* close window */
  if (cl_exit<1) {return;}
  if (fullscr) {
    XUngrabPointer(display,CurrentTime);
    XUngrabKeyboard(display,CurrentTime);
  }
  free_grafik(backpuffer);
  XFreeGC(display,gc_farbe[0]);
  XFreeGC(display,gc_farbe[1]);
  if (xvi!=NULL) {  /* created colormap */
    XFree(xvi);
    XFreeColormap(display,colormap);
    xvi=NULL;
  }
  mouse_speed(0);  /* restore old mouse speed */

  _restore_mode();

  XDestroyWindow(display,window);
  XCloseDisplay(display);
  cl_exit=0;
} /* Ende close_window */


int reopen_window(int dp) {
/* reopens window for resizing
** 1.arg: see 2.arg in open_window()
** return: see open_window()
*/
  close_window();
  return(open_window(NULL,dp));
} /* Ende reopen_window */


void get_keys() {
/* get pressed or released keys */
  static int m_x=0,m_y=0;
  int i1,i2;
  XEvent event;
  KeySym keysym;
  XComposeStatus costa;
  char key[128],* ptr;
  for (i1=0;i1<_keyi;i1++) {
    if ((_keym[i1]&8192)==0) {
      i2=_keym[i1]&~8192;
      if (_keyc[i2]==1) {_keyc[i2]=2;}
    }
  }
  if (_maus_left==1) {_maus_left=2;}
  if (_maus_right==1) {_maus_right=2;}
  if (_maus_middle==1) {_maus_middle=2;}
  if (fullscr) {
    Status sta;
    sta=XGrabKeyboard(display,window,True,GrabModeAsync,GrabModeAsync,CurrentTime);
    if (sta!=GrabSuccess) {return;}
    sta=XGrabPointer(display,window,True,ButtonPressMask|ButtonReleaseMask|PointerMotionMask|LeaveWindowMask,GrabModeAsync,GrabModeAsync,None,None,CurrentTime);
    if (sta!=GrabSuccess) {return;}
  }
  XSync(display,False);
  while (XPending(display)) {
    XNextEvent(display,&event);
    if ((event.type==KeyPress) || (event.type==KeyRelease)) {
      XLookupString(&event.xkey,key,1,&keysym,&costa);
      if ((ptr=XKeysymToString(keysym))!=NULL) {
        for (i1=0;i1<_keyi;i1++) {
          i2=_keym[i1]&~8192;
          if (strcasecmp(ptr,_keyw[i2])==0) {
            if (event.type==KeyPress) {
              if (_keyc[i2]<2) {_keyc[i2]=1;} else {_keyc[i2]=4;}
            } else if (event.type==KeyRelease) {
              if (_keyc[i2]<2) {_keyc[i2]=0;} else {_keyc[i2]=3;}
            }
          }
        }
      }
    } else if (event.type==ButtonPress) {
      if (event.xbutton.button>0) {
        if (event.xbutton.button==_maus_leftbutton) {
          if (_maus_left<2) {_maus_left=1;} else {_maus_left=4;}
        } else if (event.xbutton.button==_maus_rightbutton) {
          if (_maus_right<2) {_maus_right=1;} else {_maus_right=4;}
        } else if (event.xbutton.button==_maus_middlebutton) {
          if (_maus_middle<2) {_maus_middle=1;} else {_maus_middle=4;}
        }
        _maus_x=(event.xbutton.x-zx)/bp_doppl;
        if ((_maus_x<0) || (_maus_x>=SC_WIDTH)) {_maus_x=-1;}
        _maus_y=(event.xbutton.y-zy)/bp_doppl;
        if ((_maus_y<0) || (_maus_y>=SC_HEIGHT)) {_maus_y=-1;}
      }
    } else if (event.type==ButtonRelease) {
      if (event.xbutton.button>0) {
        if (event.xbutton.button==_maus_leftbutton) {
          if (_maus_left<2) {_maus_left=0;} else {_maus_left=3;}
        } else if (event.xbutton.button==_maus_rightbutton) {
          if (_maus_right<2) {_maus_right=0;} else {_maus_right=3;}
        } else if (event.xbutton.button==_maus_middlebutton) {
          if (_maus_middle<2) {_maus_middle=0;} else {_maus_middle=3;}
        }
        _maus_x=(event.xbutton.x-zx)/bp_doppl;
        if ((_maus_x<0) || (_maus_x>=SC_WIDTH)) {_maus_x=-1;}
        _maus_y=(event.xbutton.y-zy)/bp_doppl;
        if ((_maus_y<0) || (_maus_y>=SC_HEIGHT)) {_maus_y=-1;}
      }
    } else if (event.type==MotionNotify) {
      _maus_x=(event.xbutton.x-zx)/bp_doppl;
      if ((_maus_x<0) || (_maus_x>=SC_WIDTH)) {_maus_x=-1;}
      _maus_y=(event.xbutton.y-zy)/bp_doppl;
      if ((_maus_y<0) || (_maus_y>=SC_HEIGHT)) {_maus_y=-1;}
      if (_maus_x>-1) {m_x=event.xbutton.x;}
      if (_maus_y>-1) {m_y=event.xbutton.y;}
    } else if (event.type==EnterNotify) {
      flush_window();
    } else if (event.type==LeaveNotify) {
      _maus_x=_maus_y=-1;
    }
  }
#ifdef GRLIB_X_EXTS
  if (fullscr) {
    if ((_maus_x<0) || (_maus_y<0)) {
      XWarpPointer(display,None,None,0,0,0,0,-10000,-10000);
      XWarpPointer(display,None,None,0,0,0,0,(WidthOfScreen(DefaultScreenOfDisplay(display))+virtwidth)/2,(HeightOfScreen(DefaultScreenOfDisplay(display))+virtheight)/2);
      XWarpPointer(display,None,None,0,0,0,0,m_x-(WidthOfScreen(DefaultScreenOfDisplay(display))+virtwidth)/2,m_y-(HeightOfScreen(DefaultScreenOfDisplay(display))+virtheight)/2);
      XFlush(display);
      XSync(display,False);
      _maus_x=(m_x-zx)/bp_doppl;
      _maus_y=(m_y-zy)/bp_doppl;
    }
  }
#endif
  for (i1=0;i1<_keyi;i1++) {
    i2=_keym[i1]&~8192;
    if (_keyc[i2]==3) {_keyc[i2]=0;}
  }
  if (_maus_left==3) {_maus_left=0;}
  if (_maus_right==3) {_maus_right=0;}
  if (_maus_middle==3) {_maus_middle=0;}
} /* Ende get_keys */


void clearstate() {
  int i1;
  XSync(display,True);
  for (i1=0;i1<KEYS_INDEX;i1++) {_keyc[i1]=3;}
  _maus_left=_maus_middle=_maus_right=3;
} /* Ende clearstate */


int mouse_speed(int index) {
/* speed of mouse, from 1=slow to 3=fast; returns previous speed index */
  static int j1=0,j2,j3,mvs=1;
  int vs;
  if (j1==0) {XGetPointerControl(display,&j1,&j2,&j3);}
  if (index<0) {index=0;} else if (index>3) {index=3;}
  if (index==0) {  /* restore old mouse speed */
    XChangePointerControl(display,True,True,j1,j2,j3);
    vs=mvs;
  } else {
    XChangePointerControl(display,True,True,10,(40-index*10)/bp_doppl,5);
    vs=mvs;
    mvs=index;
  }
  return(vs);
} /* Ende mouse_speed */


void brightness(int vol) {
/* reduces or increases brightness of colormap
** (all graphics should be drawn again to take effect of it)
** 1.arg: -63 (darkest) to 62 (lightest), 0 is default, or 99=last brightness
*/
  static int lastvol=0;
  int r,g,b;
  int i1,i2,i3;
  float f1;
  XColor xc;
  unsigned long ul;
  if (vol==99) {vol=lastvol;}
  else if (vol<-63) {vol=-63;}
  else if (vol>62) {vol=62;}
  lastvol=vol;
  if (colfirst==0) {
    XFreeGC(display,gc_farbe[0]);
    XFreeGC(display,gc_farbe[1]);
  }
  for (i1=0;i1<256;i1++) {  /* fx: color map of e.g. RGB256_FILE */
    i3=vol;
    r=fx[i1].r;
    g=fx[i1].g;
    b=fx[i1].b;
    i2=(r>g?(r>b?r:b):(g>b?g:b));
    if (i2>0) {
      if (i2+i3>63) {i3=63-i2;}
      f1=(float)i3/(float)i2;
      r+=(f1*r);
      g+=(f1*g);
      b+=(f1*b);
      if (r<0) {r=0;} else if (r>63) {r=63;}
      if (g<0) {g=0;} else if (g>63) {g=63;}
      if (b<0) {b=0;} else if (b>63) {b=63;}
    }
    r<<=2; g<<=2; b<<=2;
    xc.red=r*256; xc.green=g*256; xc.blue=b*256;
    xc.flags=DoRed|DoGreen|DoBlue;
    if (xvi!=NULL) {  /* created colormap */
      ul=(unsigned long)i1;
      xc.pixel=ul;
      XStoreColor(display,colormap,&xc);
    } else {  /* default colormap */
      if (XAllocColor(display,colormap,&xc)!=0) {ul=xc.pixel;} else {ul=px_white;}
    }
    if (i1==_rgb_black) {gc_farbe[0]=_create_gc(window,ul);}
    else if (i1==_rgb_white) {gc_farbe[1]=_create_gc(window,ul);}
    colpix[i1]=ul;
  }
  if (xvi!=NULL) {  /* created colormap */
    XSetWindowColormap(display,window,colormap);
    XInstallColormap(display,colormap);
  }
} /* Ende brightness */
