/* create_sunnyboy.c
   Create a bitmap with a sunnyboy
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


bitmap * create_sunnyboy(int);


/* function to return a created sunnyboy bitmap */

bitmap * create_sunnyboy(int color) {
  /* give back a bitmap with a sunnyboy */
  int x,y,r;
  bitmap * sunboy;
  r=10;  // radius of face of Sunnyboy

  /* create empty bitmap, large enough for sunnyboy */
  sunboy=vg_bitmap_createnew(r*2+1,r*2+1);
  if (sunboy==NULL) {return(NULL);}  // error

  /* get middle of bitmap */
  x=vg_bitmap_width(sunboy)/2;
  y=vg_bitmap_height(sunboy)/2;

  /* draw sunnyboy into the middle of the bitmap */
  vg_draw_circle(sunboy,x,y,r,RGB_WHITE,0);
  vg_draw_fillout(sunboy,x,y,color);
  // draw eyes, nose and mouth.
  // We use RGB_DARK instead of RGB_BLACK, because RGB_BLACK is not only
  // black but may also be considered as transparent pixel, which is not
  // drawn, if the bitmap is copied in transparent mode.
  // RGB_DARK is the next darkest pixel, which is always drawn.
  vg_draw_box(sunboy,x-4,y-4,2,2,RGB_DARK,0);
  vg_draw_box(sunboy,x+4,y-4,2,2,RGB_DARK,0);
  vg_draw_pixel(sunboy,x-1,y,RGB_DARK);
  vg_draw_pixel(sunboy,x+1,y,RGB_DARK);
  vg_draw_pixel(sunboy,x-4,y+3,RGB_DARK);
  vg_draw_pixel(sunboy,x+4,y+3,RGB_DARK);
  vg_draw_line(sunboy,x-3,y+4,x-2,y+4,RGB_DARK);
  vg_draw_line(sunboy,x+3,y+4,x+2,y+4,RGB_DARK);
  vg_draw_line(sunboy,x-1,y+5,x+1,y+5,RGB_DARK);

  return(sunboy);
}
