#ifndef GAME_H
#define GAME_H

#include <stdlib.h>

static char serverport[]="2222";  /* port of network-server */
static char mbcastport[]="2223";  /* broadcast/multicast port to get server-ip */

static void intro(void);
static void extro(int);


static void intro() {
/* show short intro */
  bitmap * bmp;
  char buf[512];
  snprintf(buf,sizeof(buf),"A Demogame for 1 to 3 players.\n\nMove with the arrow keys,\nshoot the rocks with left CTRL.\n\nQuit with Return-key.");
  vg_bitmap_clear(NULL,RGB_BLACK);
  bmp=vg_bitmap_createfromtext(RGB_WHITE,RGB_BLACK,4,1,buf,NULL);
  vg_bitmap_copyto(NULL,SC_WIDTH/2,SC_HEIGHT/2,bmp,0,0,0,0,RGB_FULL);
  vg_bitmap_free(bmp);
  snprintf(buf,sizeof(buf),"[Return]");
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,SC_HEIGHT-30,buf,NULL,RGB_FULL);
  vg_window_flush();
  for (;;) {
    vg_key_update();
    if (vg_key_pressed(KEY_ENTER,SHORTKEY)) {break;}
    if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {break;}
    vg_wait_time(50);
  }
} /* end intro */


static void extro(int creds) {
/* show short extro */
  char buf[64];
  snprintf(buf,sizeof(buf),"Score: %d",creds);
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  sleep(3);
} /* end extro */


#endif /* GAME_H */
