/* main program for client-players */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>
#include "main.h"
#include "game.h"
#include "ifo.h"

static int connect_server(void);
static int not_alive(void);


int main(int argc, char ** argv) {
  char buf[64];
  int creds;
  /* objects */
  struct o_ship * ships;
  struct o_rock * rocks;
  struct o_shot * shots;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if (vg_window_open("demogame",0,0) < 0) {exit(1);}

  /* start soundserver */
  if (vg_sound_startserver(0,0,NULL) < 0) {vg_window_close(); exit(1);}
  vg_sound_attach("sounds/FSKeeper.mid","s-music",100);

  /* show intro */
  intro();


  /* +++ start networking +++ */

  /* network variables will be set, when we create the objects */
  snprintf(buf,sizeof(buf),"Creating objects ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if ((ships=new_ship())==NULL) {goto endgame;}
  if ((shots=new_shot(10))==NULL) {goto endgame;}
  if ((rocks=new_rock(40))==NULL) {goto endgame;}

  /* connect to network-server */
  if (connect_server() < 0) {goto endgame;}

  /* initialize objects and get network pointers */
  if ((ships->set_network(vg_nw_maxplayer())) < 0) {goto endgame;}
  if ((shots->set_network(vg_nw_maxplayer())) < 0) {goto endgame;}
  if ((rocks->set_network()) < 0) {goto endgame;}

  /* receive initial packet from master */
  if (vg_nw_recvinit()<0) {goto endgame;}


  /* +++ game loop +++ */

  vg_sound_play("s-music",0,0);
  for (;;) {
    /* clear window */
    vg_bitmap_clear(NULL,RGB_BLACK);

    /* get keystrokes */
    if (vg_key_update()<0) {break;}  /* network closed */
    if (not_alive()) {break;}  /* client dead */
    if (vg_key_pressed(KEY_ENTER,SHORTKEY)) {  /* quit with return-key */
      ships->killship();  /* kill your ship */
      break;
    }

    /* get positions of objects */
    ships->getpos();
    shots->getpos();
    rocks->getpos();

    /* give out objects */
    ships->giveout();
    shots->giveout();
    rocks->giveout();

    vg_window_flush();  /* flush all out to window */
    vg_wait_time(50);  /* loop delay */
  }  /* end game loop */

  vg_sound_stop("s-music",0);
  creds=ships->get_credits();
  free_ship();
  free_shot();
  free_rock();
  extro(creds);  /* show credits */

endgame:
  vg_nw_close();
  vg_sound_endserver();
  vg_window_close();
  exit(0);
} /* end main */


static int connect_server() {
/* make connection to server */
  char buf[64];

  /* connect to network-server via broadcast/multicast */
  snprintf(buf,sizeof(buf),"Connecting to network-server ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_connect(PROTO_UDP,NULL,serverport,mbcastport) < 0) {return(-1);}

  /* wait for all other connects */
  snprintf(buf,sizeof(buf),"Waiting for other players ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_waitforconnects()<0) {vg_nw_close(); return(-1);}

  return(0);
} /* end connect_server */


static int not_alive() {
/* check whether client is alive */
  return(!vg_nw_isalive(vg_nw_myplayer()));
} /* end not_alive */
