/* main program for master-player */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>
#include "main.h"
#include "game.h"
#include "ifo.h"

static int start_server(int,int);
static int all_dead(int);


int main(int argc, char ** argv) {
  const int nop_from=2,nop_to=3;  /* number of players: from and to */
  char buf[64];
  int creds;
  /* objects */
  struct o_ship * ships;
  struct o_rock * rocks;
  struct o_shot * shots;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if (vg_window_open("demogame",0,0) < 0) {exit(1);}

  /* start soundserver */
  if (vg_sound_startserver(0,0,NULL) < 0) {vg_window_close(); exit(1);}
  vg_sound_attach("sounds/FSKeeper.mid","s-music",100);

  /* show intro */
  intro();


  /* +++ start networking +++ */

  /* network variables will be set, when we create the objects */
  snprintf(buf,sizeof(buf),"Creating objects ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if ((ships=new_ship())==NULL) {goto endgame;}
  if ((shots=new_shot(10))==NULL) {goto endgame;}
  if ((rocks=new_rock(40))==NULL) {goto endgame;}

  /* start network-server and connect to it,
  ** pass the number of players we want to have
  */
  if (start_server(nop_from,nop_to) < 0) {goto endgame;}

  /* initialize objects and get network pointers */
  if ((ships->set_network(vg_nw_maxplayer())) < 0) {goto endgame;}
  if ((shots->set_network(vg_nw_maxplayer())) < 0) {goto endgame;}
  if ((rocks->set_network()) < 0) {goto endgame;}

  /* send initial packet to clients */
  vg_nw_sendinit();


  /* +++ game loop +++ */

  vg_sound_play("s-music",0,0);
  for (;;) {
    /* clear window */
    vg_bitmap_clear(NULL,RGB_BLACK);

    /* get keystrokes */
    if (vg_key_update()<0) {break;}  /* network closed */
    if (all_dead(0)) {break;}  /* all players dead */
    if (vg_key_pressed(KEY_ENTER,SHORTKEY)) {  /* quit-request with return-key */
      if (!vg_nw_isalive(vg_nw_myplayer())) {  /* second hit */
        if (all_dead(1)) {break;}  /* all real players dead: quit */
      } else {
        ships->killship();  /* kill your ship, but don't quit */
      }
    }

    /* inform objects about a new loop */
    ships->refresh();
    shots->refresh();
    rocks->refresh();

    /* move objects */
    ships->move();
    shots->move();
    rocks->move();
    vg_nw_sendcommon();

    /* give out objects */
    ships->giveout();
    shots->giveout();
    rocks->giveout();

    vg_window_flush();  /* flush all out to window */
    vg_wait_time(50);  /* loop delay */
  }  /* end game loop */

  vg_sound_stop("s-music",0);
  creds=ships->get_credits();
  free_ship();
  free_shot();
  free_rock();
  extro(creds);  /* show credits */

endgame:
  vg_nw_close();
  vg_sound_endserver();
  vg_window_close();
  exit(0);
} /* end main */


static int start_server(int nop_from,int nop_to) {
/* start and make connection to server
** 1.+2.arg: number of players: at least and at most
*/
  char buf[64];

  /* set number of players */
  if (vg_nw_setplayer(nop_from,nop_to) < nop_from) {return(-1);}

  /* start network-server and connect to it */
  snprintf(buf,sizeof(buf),"Starting network-server ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_startserver(PROTO_UDP,serverport,20,4,mbcastport,30)<0) {return(-1);}

  /* wait for all other connects */
  snprintf(buf,sizeof(buf),"Waiting for other players ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_waitforconnects()<0) {vg_nw_close(); return(-1);}

  return(0);
} /* end start_server */


static int all_dead(int only_real) {
/* check whether all (real) players are dead */
  int ia,ie;
  if (only_real) {ie=vg_nw_virtualplayer();} else {ie=vg_nw_maxplayer()+1;}
  for (ia=1;ia<ie;ia++) {
    if (vg_nw_isalive(ia)) {break;}
  }
  if (ia==ie) {return(1);}  /* all dead */
  return(0);
} /* end all_dead */
