/* Rock interface */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames2.h>
#include "main.h"
#include "ifo.h"

void iforock_move(struct o_rock *,int);  /* interface call */


void iforock_move(struct o_rock * obj,int idx) {
/* check for interaction with other objects and move rocks
** 1.arg: object for rocks
** 2.arg: index number of actual rock
*/
  int inr;
  struct ovlap ovl;
  struct o_shot * shots=obj_shot();
  struct o_ship * ships=obj_ship();

  /* +++ check for interaction with shots +++ */

  inr=shots->overlapped(&ovl,obj->rocks[idx].mbp,(int)obj->rocks[idx].xpos,(int)obj->rocks[idx].ypos,(int)(obj->rocks[idx].xpos+obj->rocks[idx].xadd),(int)(obj->rocks[idx].ypos+obj->rocks[idx].yadd));
  if (inr>=0) {  /* hit by a shot */
    ships->inc_credit(shots->get_ship(inr));
    shots->set_inactive(inr);
    obj->rocks[idx].xpos=(float)ovl.x_hit;
    obj->rocks[idx].ypos=(float)ovl.y_hit;
    obj->set_dead(idx);
    return;
  }

  /* +++ check for interaction with ships +++ */

  inr=ships->overlapped(&ovl,obj->rocks[idx].mbp,(int)obj->rocks[idx].xpos,(int)obj->rocks[idx].ypos,(int)(obj->rocks[idx].xpos+obj->rocks[idx].xadd),(int)(obj->rocks[idx].ypos+obj->rocks[idx].yadd));
  if (inr>=0) {  /* hit a ship */
    ships->set_dead(inr);
    obj->rocks[idx].xpos=(float)ovl.x_hit;
    obj->rocks[idx].ypos=(float)ovl.y_hit;
    obj->set_dead(idx);
    return;
  }

  /* +++ check for interaction with other rocks +++ */

  inr=obj->overlapped(1,&ovl,obj->rocks[idx].mbp,(int)obj->rocks[idx].xpos,(int)obj->rocks[idx].ypos,(int)(obj->rocks[idx].xpos+obj->rocks[idx].xadd),(int)(obj->rocks[idx].ypos+obj->rocks[idx].yadd));
  if (inr>=0) {  /* hit another rock */
    if (ovl.hitside&(VG_RIGHT|VG_LEFT)) {  /* exchange x-directions */
      obj->change_direction(inr,&obj->rocks[idx].xadd,NULL);
    } else if (ovl.hitside&(VG_TOP|VG_BOTTOM)) {  /* exchange y-directions */
      obj->change_direction(inr,NULL,&obj->rocks[idx].yadd);
    } else {  /* exchange x- and y-directions */
      obj->change_direction(inr,&obj->rocks[idx].xadd,&obj->rocks[idx].yadd);
    }
    obj->rocks[idx].xpos=(float)ovl.x_hit+obj->rocks[idx].xadd;
    obj->rocks[idx].ypos=(float)ovl.y_hit+obj->rocks[idx].yadd;
    return;
  }

  /* +++ move it +++ */
  obj->rocks[idx].xpos+=obj->rocks[idx].xadd;
  obj->rocks[idx].ypos+=obj->rocks[idx].yadd;
} /* end iforock_move */
