/* Ship interface */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames2.h>
#include "main.h"
#include "ifo.h"

void ifoship_move(struct o_ship *,int);  /* interface call */
int ifoship_shot(struct o_ship *,int);  /* interface call */


void ifoship_move(struct o_ship * obj,int idx) {
/* check for interaction with other objects and move ships
** 1.arg: object for ships
** 2.arg: index number of actual ship
*/
  int inr;
  struct ovlap ovl;
  struct o_rock * rocks=obj_rock();

  /* +++ check for interaction with rocks +++ */

  inr=rocks->overlapped(0,&ovl,obj->ships[idx].bmp,obj->ships[idx].xpos,obj->ships[idx].ypos,obj->ships[idx].xpos+obj->ships[idx].xadd,obj->ships[idx].ypos+obj->ships[idx].yadd);
  if (inr>=0) {  /* hit a rock */
    obj->inc_credit(idx);
    rocks->set_dead(inr);
    obj->ships[idx].xpos=ovl.x_hit;
    obj->ships[idx].ypos=ovl.y_hit;
    obj->set_dead(idx);
    return;
  }

  /* +++ move it +++ */
  obj->ships[idx].xpos+=obj->ships[idx].xadd;
  obj->ships[idx].ypos+=obj->ships[idx].yadd;
} /* end ifoship_move */


int ifoship_shot(struct o_ship * obj,int idx) {
/* release shot if possible
** 1.arg: object for ships
** 2.arg: index number of actual ship
** return: whether released (=1) or not (=0)
*/
  struct o_shot * shots=obj_shot();
  if (obj->ships[idx].shotpause>0) {return(0);}
  return(shots->activate(idx,obj->ships[idx].xpos,obj->ships[idx].ypos-vg_bitmap_height(obj->ships[idx].bmp)/2));
} /* end ifoship_shot */
