/* Shot interface */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames2.h>
#include "main.h"
#include "ifo.h"

void ifoshot_move(struct o_shot *,int);  /* interface call */


void ifoshot_move(struct o_shot * obj,int idx) {
/* check for interaction with other objects and move shots
** 1.arg: object for shots
** 2.arg: index number of actual shot
*/
  int inr;
  struct ovlap ovl;
  struct o_rock * rocks=obj_rock();

  /* +++ check for interaction with rocks +++ */

  inr=rocks->overlapped(0,&ovl,obj->shots[idx].bmp,obj->shots[idx].xpos,obj->shots[idx].ypos,obj->shots[idx].xpos,obj->shots[idx].ypos+obj->shots[idx].yadd);
  if (inr>=0) {  /* hit a rock */
    struct o_ship * ships=obj_ship();
    ships->inc_credit(obj->get_ship(idx));
    rocks->set_dead(inr);
    obj->shots[idx].xpos=ovl.x_hit;
    obj->shots[idx].ypos=ovl.y_hit;
    obj->set_inactive(idx);
    return;
  }

  /* +++ move it +++ */
  obj->shots[idx].ypos+=obj->shots[idx].yadd;
} /* end ifoshot_move */
