#ifndef O_ROCK_H
#define O_ROCK_H

#include <vgagames2.h>

struct o_rock {
  /* functions for all rocks */
  int (*set_network)(void);  /* set network pointers for rocks after network-connection */
  void (*refresh)(void);     /* (master:) called before entering a new loop */
  void (*move)(void);        /* (master:) move rocks */
  void (*getpos)(void);      /* (clients:) get positions of rocks */
  void (*giveout)(void);     /* give out rocks */

  /* interface functions */
  int (*overlapped)(int,struct ovlap *,bitmap *,int,int,int,int);
  void (*change_direction)(int,float *,float *);
  void (*set_dead)(int);

  /* variable struct for each rock */
  int anzahl;         /* number of rocks */
  struct {
    sprite * bild;    /* rock-bitmaps */
    bitmap * mbp;     /* actual bitmap */
    float xpos,ypos;  /* position */
    float xadd,yadd;  /* moving x and y values */
    int status;       /* 0=OK, >0=exploding */
    int dreh,dmom;    /* rotating velocity, counter */
    /* network variables in common-block */
    short * n_xpos;       /* x-position */
    short * n_ypos;       /* y-position */
    short * n_status;     /* status */
    short * n_spritepos;  /* position number of sprite bild */
  } * rocks;
  char * n_snd_hit;  /* network: play s-rockhit */
};

/* initializing and destroying function for rocks */
extern struct o_rock * new_rock(int);  /* before network-connection */
extern struct o_rock * obj_rock(void);
extern void free_rock(void);

#endif /* O_ROCK_H */
