#ifndef O_SHIP_H
#define O_SHIP_H

#include <vgagames2.h>

struct o_ship {
  /* functions for all ships */
  int (*set_network)(int);   /* set network pointers for ships after network-connection */
  void (*refresh)(void);     /* (master:) called before entering a new loop */
  void (*move)(void);        /* (master:) move ships */
  void (*getpos)(void);      /* (clients:) get positions of ships */
  void (*giveout)(void);     /* give out ships */
  void (*killship)(void);    /* kill your ship */
  int (*get_credits)(void);  /* return credits */

  /* interface functions */
  int (*overlapped)(struct ovlap *,bitmap *,int,int,int,int);
  void (*set_dead)(int);
  void (*inc_credit)(int);

  /* variable struct for each ship */
  int anzahl;         /* number of ships */
  struct {
    bitmap * bmp;     /* ship bitmap */
    int xpos,ypos;    /* position */
    int xadd,yadd;    /* moving x and y values */
    int status;       /* 0=dead, 1=OK, >1=exploding */
    int shotpause;    /* count for next shot release */
    int accel;        /* if set, draw accelerating flame */
    int credit;       /* ship's credits */
    int plno;         /* network player's number */
    /* network variables in common-block */
    unsigned short * n_xypos;  /* x-/y-position (y*SC_WIDTH+x) */
    unsigned char * n_status;  /* status */
    char * n_accel;            /* accelerating? */
    int * n_credit;            /* ship's credits */
    char * n_shiphit;          /* play ship-hit */
    char * n_shipshot;         /* play/pause ship-shot */
  } * ships;
};

/* initializing and destroying function for ships */
extern struct o_ship * new_ship(void);  /* before network-connection */
extern struct o_ship * obj_ship(void);
extern void free_ship(void);

#endif /* O_SHIP_H */
