#ifndef O_SHOT_H
#define O_SHOT_H

#include <vgagames2.h>

struct o_shot {
  /* functions for all shots */
  int (*set_network)(int);       /* set network pointers for shots after network-connection */
  void (*refresh)(void);         /* (master:) called before entering a new loop */
  void (*move)(void);            /* (master:) move shots */
  void (*getpos)(void);          /* (clients:) get positions of shots */
  void (*giveout)(void);         /* give out shots */
  int (*activate)(int,int,int);  /* (ships:) make a shot active */

  /* interface functions */
  int (*overlapped)(struct ovlap *,bitmap *,int,int,int,int);
  void (*set_inactive)(int);
  int (*get_ship)(int);

  /* variable struct for each shot */
  int anzahl;         /* maximum number of shots */
  struct {
    bitmap * bmp;     /* shot bitmap */
    int xpos,ypos;    /* position */
    int yadd;         /* moving y values */
    int status;       /* 0=inactive, >0=active (ship's indexnumber+1) */
    /* network variables in common-block */
    unsigned short * n_xypos;  /* x-/y-position (y*SC_WIDTH+x) */
    unsigned char * n_status;  /* status */
  } * shots;
};

/* initializing and destroying function for shots */
extern struct o_shot * new_shot(int);  /* before network-connection */
extern struct o_shot * obj_shot(void);
extern void free_shot(void);

#endif /* O_SHOT_H */
