/* tut-bitmap1.c
   Create a bitmap with a sunnyboy in a subfunction,
   show it and end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * sunboy;  // for the created sunnyboy

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create a green sunnyboy */
  sunboy=create_sunnyboy(vg_color_index(CL_GREEN,100));
  if (sunboy==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* copy sunnyboy to window */
  {int x,y;
   // copy it to the middle of the window,
   // vg_bitmap_copyto() copies the middle of the sunnyboy
   // to the destination coordinates.
   x=SC_WIDTH/2;
   y=SC_HEIGHT/2;
   // we use RGB_TRANS to copy only the face, not the edges
   vg_bitmap_copyto(NULL,x,y,sunboy,0,0,0,0,RGB_TRANS);
  }

  /* now flush window out to visible screen */
  vg_window_flush();

  /* wait 3 seconds */
  sleep(3);

  /* free bitmap */
  vg_bitmap_free(sunboy);

  /* close window */
  vg_window_close();

  exit(0);
}
