/* tut-bitmap2.c
   Create a bitmap with a sunnyboy,
   save it as a VgaGames-bitmap-format file,
   load and show it, then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * sunboy;  // for the created sunnyboy

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create an orange sunnyboy */
  sunboy=create_sunnyboy(vg_color_index(CL_ORANGE,100));
  if (sunboy==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* save sunnyboy as a file in VgaGames-bitmap-format,
     we use directory share/ because it is writable
  */
  vg_bitmap_save(sunboy,"share/sunnyboy.vga",VGAFORMAT_VGA);

  /* now we want to load it */
  vg_bitmap_free(sunboy);  // at first free bitmap
  sunboy=vg_bitmap_createfromfile("share/sunnyboy.vga");
  if (sunboy==NULL) {  // error
    fprintf(stderr,"Bad luck - could not load sunnyboy.vga\n");
  }

  /* give it out */
  if (sunboy!=NULL) {
    int x,y;
    x=SC_WIDTH/2;
    y=SC_HEIGHT/2;
    vg_bitmap_copyto(NULL,x,y,sunboy,0,0,0,0,RGB_TRANS);

    /* free bitmap (and remove it) */
    vg_bitmap_free(sunboy);
    unlink("share/sunnyboy.vga");

    /* now flush window out to visible screen */
    vg_window_flush();

    /* wait 3 seconds */
    sleep(3);
  }

  /* close window */
  vg_window_close();

  exit(0);
}
