/* tut-bitmap3.c
   Create a bitmap with a sunnyboy, let it run from left to right,
   then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * sunboy;  // for the created sunnyboy

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create a green sunnyboy */
  sunboy=create_sunnyboy(vg_color_index(CL_GREEN,100));
  if (sunboy==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* let sunnyboy run from left to right */
  {int x_start,x_end,y;
   // x_start: where to start sunnyboy in x-direction
   x_start=-(vg_bitmap_width(sunboy)/2);
   // x_start: where to end sunnyboy in x-direction
   x_end=SC_WIDTH+(vg_bitmap_width(sunboy)/2);
   // y is always the same
   y=SC_HEIGHT/2;

   /* give out sunnyboy, flush window and wait a time */
   for (; x_start <= x_end; x_start++) {
     vg_bitmap_clear(NULL,RGB_BLACK);  // clear window
     vg_bitmap_copyto(NULL,x_start,y,sunboy,0,0,0,0,RGB_TRANS);  // give out
     vg_window_flush();  // flush window
     vg_wait_time(30);  // wait up to 30 milliseconds
   }
  }

  /* free bitmap */
  vg_bitmap_free(sunboy);

  /* close window */
  vg_window_close();

  exit(0);
}
