/* tut-bitmap4.c
  Create a bitmap with a sunnyboy, rotate and zoom it,
  give it and the original out, then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * sunboy;  // for the created sunnyboy
  bitmap * sunboy2; // for the modified sunnyboy

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create a green sunnyboy */
  sunboy=create_sunnyboy(vg_color_index(CL_GREEN,100));
  if (sunboy==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* rotate sunnyboy at 180 degrees and zoom it twice as big.
     Because both functions return a static bitmap, we can
     chain them. The original sunboy is not touched.
  */
  sunboy2=vg_bitmap_zoom(vg_bitmap_rotate(sunboy,180), 2.0, 2.0);
  if (sunboy2==NULL) {  // error
    vg_window_close();
    exit(1);
  }
  // now we want to duplicate this static bitmap, because it will be
  // modified at the next call to vg_bitmap_rotate() or vg_bitmap_zoom()
  sunboy2=vg_bitmap_duplicate(sunboy2);
  if (sunboy2==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* give out the original sunnyboy and the modified one */
  vg_bitmap_copyto(NULL,SC_WIDTH/2,SC_HEIGHT/3,sunboy,0,0,0,0,RGB_TRANS);
  vg_bitmap_copyto(NULL,SC_WIDTH/2,SC_HEIGHT*2/3,sunboy2,0,0,0,0,RGB_TRANS);

  /* now flush window out to visible screen */
  vg_window_flush();

  /* wait 3 seconds */
  sleep(3);

  /* free both sunnyboys */
  vg_bitmap_free(sunboy);
  vg_bitmap_free(sunboy2);  // free it, because it was duplicated

  /* close window */
  vg_window_close();

  exit(0);
}
