/* tut-color1.c
   Create a bitmap with a sunnyboy, fill it with the colorindex of yellow,
   load another colormap,
   you see that the sunnyboy changed its color
   according to the new color of its colorindex,
   create another sunnyboy, fill it with the new colorindex of yellow,
   load the previous colormap,
   you see that the two sunnyboys have different colors
   because of different colorindexes,
   become darker,
   then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * sunboy1,* sunboy2;  // for the created sunnyboys
  char colm[128];  // save original colormap
  int i1,cl1,cl2;
  char buf[32];

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create a sunnyboy as yellow as possible and give it out */
  cl1=vg_color_index(CL_YELLOW,100);
  sunboy1=create_sunnyboy(cl1);
  if (sunboy1==NULL) {  // error
    vg_window_close();
    exit(1);
  }
  vg_bitmap_copyto(NULL,SC_WIDTH/4,SC_HEIGHT/2,sunboy1,0,0,0,0,RGB_FULL);
  snprintf(buf,sizeof(buf),"%d",cl1);
  vg_draw_text(NULL,RGB_WHITE,SC_WIDTH/4-strlen(buf)*vg_font_width(NULL)/2,SC_HEIGHT/2+vg_bitmap_width(sunboy1),buf,NULL,RGB_FULL);
  vg_window_flush();  // flush window
  sleep(3);

  /* load another colormap and save the current into colm */
  vg_load_colormap("test1.clm",colm,sizeof(colm));
  vg_window_flush();  // flush window
  sleep(3);

  /* create another sunnyboy as yellow as possible and give it out */
  cl2=vg_color_index(CL_YELLOW,100);
  sunboy2=create_sunnyboy(cl2);
  if (sunboy2==NULL) {  // error
    vg_window_close();
    exit(1);
  }
  vg_bitmap_copyto(NULL,SC_WIDTH*3/4,SC_HEIGHT/2,sunboy2,0,0,0,0,RGB_FULL);
  snprintf(buf,sizeof(buf),"%d",cl2);
  vg_draw_text(NULL,RGB_WHITE,SC_WIDTH*3/4-strlen(buf)*vg_font_width(NULL)/2,SC_HEIGHT/2+vg_bitmap_width(sunboy2),buf,NULL,RGB_FULL);
  vg_window_flush();  // flush window
  sleep(3);

  /* load previous colormap */
  vg_load_colormap(colm,NULL,0);
  vg_window_flush();  // flush window
  sleep(3);

  /* become darker and darker, from current value to -63 */
  for (i1=vg_brightness(0);i1>=-63;i1--) {
    vg_brightness(i1);
    vg_window_flush();  // flush window
    vg_wait_time(30);
  }

  /* free bitmaps */
  vg_bitmap_free(sunboy1);
  vg_bitmap_free(sunboy2);

  /* close window */
  vg_window_close();

  exit(0);
}
