/* tut-drawing1.c
   Draw a not-filled box and then fill it out with green.
   Then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* draw a not-filled box */
  {int x,y,w,h,col;
   w=50;  // width of box=50
   h=50;  // height of box=50
   // draw box into the middle of the window
   // x/y is left upper corner of the box
   x=(SC_WIDTH-w)/2;
   y=(SC_HEIGHT-h)/2;
   vg_draw_box(NULL,x,y,w,h,RGB_WHITE,0);

   /* now flush window out to visible screen */
   vg_window_flush();

   /* wait 2 seconds */
   sleep(2);

   /* fill box out with color green */
   col=vg_color_index(CL_GREEN,100);  // get color-index of green
   vg_draw_fillout(NULL,x+1,y+1,col);  // (x+1/y+1) is inside the box

   /* now flush window out to visible screen */
   vg_window_flush();

   /* wait 2 seconds */
   sleep(2);
  }

  /* close window */
  vg_window_close();

  exit(0);
}
