/* tut-drawing2.c
   Draw a Sunnyboy, then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* draw a sunnyboy */
  {int x,y,r,col;
   r=10;  // radius of face of Sunnyboy
   // draw sunnyboy into the middle of the window
   // x/y is middle of circle (face)
   x=SC_WIDTH/2;
   y=SC_HEIGHT/2;
   vg_draw_circle(NULL,x,y,r,RGB_WHITE,0);
   col=vg_color_index(CL_GREEN,100);
   vg_draw_fillout(NULL,x,y,col);
   // draw eyes, nose and mouth
   vg_draw_box(NULL,x-4,y-4,2,2,RGB_BLACK,0);
   vg_draw_box(NULL,x+4,y-4,2,2,RGB_BLACK,0);
   vg_draw_pixel(NULL,x-1,y,RGB_BLACK);
   vg_draw_pixel(NULL,x+1,y,RGB_BLACK);
   vg_draw_pixel(NULL,x-4,y+3,RGB_BLACK);
   vg_draw_pixel(NULL,x+4,y+3,RGB_BLACK);
   vg_draw_line(NULL,x-3,y+4,x-2,y+4,RGB_BLACK);
   vg_draw_line(NULL,x+3,y+4,x+2,y+4,RGB_BLACK);
   vg_draw_line(NULL,x-1,y+5,x+1,y+5,RGB_BLACK);
  }

  /* now flush window out to visible screen */
  vg_window_flush();

  /* wait 3 seconds */
  sleep(3);

  /* close window */
  vg_window_close();

  exit(0);
}
