/* tut-film1.c
   showing c-code how to play a film with an explicite film-subfunction
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int filmfunk(int);  /* film-subfunction */


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  char filmpath[256];

  /* check for parameter and set filmpath */
  if (argc < 2) {
    fprintf(stderr,"Usage: %s <2|3>\n",argv[0]);
    fprintf(stderr,"Plays film/film-<2|3>/film.film\n");
    exit(1);
  }
  snprintf(filmpath,sizeof(filmpath),"film/film-%d/film.film",atoi(argv[1]));

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* start soundserver */
  if (vg_sound_startserver(0,0,NULL) < 0) {vg_window_close(); exit(1);}

  /* load and play film "film/film-?/film.film" using film-subfunction filmfunk */
  if (vg_film_play(filmpath,filmfunk) < 0) {vg_sound_endserver(); vg_window_close(); exit(1);}

  /* end soundserver and close window */
  vg_sound_endserver();
  vg_window_close();

  exit(0);
}


int filmfunk(int msec) {
/* (optional) subfunction for film
** we have at least to do:
**   vg_window_flush();
**   vg_wait_time(msec);
**   return(0);
** but we want to do more:
**  - when hit SPACE, end the film
**  - when hit ENTER, pause/continue the film
**  - and give out the actual position of film for debugging purposes
*/
  /* give out actual position of film */
  int i1,i2,i3;
  char buf[64];
  vg_film_position(&i1,&i2,&i3);
  snprintf(buf,sizeof(buf),"Position: %d,%d,%d",i1,i2,i3);
  vg_draw_text(NULL,RGB_WHITE,0,0,buf,NULL,RGB_TRANS);

  /* flush out to window */
  vg_window_flush();

  /* check for keypress to stop or pause/continue film */
  vg_key_update();
  if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {return(1);}  /* stop film */
  if (vg_key_pressed(KEY_ENTER,SHORTKEY)) {  /* pause film */
    vg_sound_paus("ALL");  /* pause all sound */
    do {  /* check for a keypress to continue film */
      vg_window_flush();
      vg_wait_time(msec);
      vg_key_update();
      if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {return(1);}  /* stop film */
    } while (vg_key_pressed(KEY_ENTER,SHORTKEY)==0);
    vg_sound_cont("ALL");  /* continue all sound */
    return(0);
  }

  /* wait the required time */
  vg_wait_time(msec);

  return(0);
} /* end filmfunk */
