/* tut-font1.c
  Show the difference between drawing a text with vg_draw_text()
  and vg_bitmap_createfromtext(), then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  char buf[128];  // for the text
  bitmap * bmptext;  // bitmap containing text
  int x,y;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* draw two lines of text to the middle of the window with vg_draw_text() */
  // first line
  snprintf(buf,sizeof(buf),"This is the first line");
  // calculate start position of text:
  // we want to use the default 8x8.font, passing NULL.
  // The number of pixels used in x-direction for the text is:
  //   strlen(buf)*vg_font_width(NULL)
  // the number of pixels used in y-direction for the text is:
  //   vg_font_height(NULL)
  x=(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2;
  y=(SC_HEIGHT-vg_font_height(NULL))/2;
  // we want to give out two lines with 4 pixels between them
  y-=6;  // (-8-4)/2
  vg_draw_text(NULL,RGB_WHITE,x,y,buf,NULL,RGB_FULL);
  // second line
  snprintf(buf,sizeof(buf),"the second line");
  x=(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2;
  y+=12;
  vg_draw_text(NULL,RGB_WHITE,x,y,buf,NULL,RGB_FULL);

  /* now flush window out to visible screen and wait 3 seconds */
  vg_window_flush();
  sleep(3);
  vg_bitmap_clear(NULL,RGB_BLACK);  // clear window

  /* draw the same two lines, created as a bitmap */
  // "\n" or "\\n" indicates the line break
  snprintf(buf,sizeof(buf),"This is the first line\\nthe second line");
  bmptext=vg_bitmap_createfromtext(RGB_BLACK,RGB_WHITE,4,1,buf,NULL);
  if (bmptext==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* copy bitmap to window, flush it and wait 3 seconds */
  // put the center of the bitmap to the center of the window
  x=SC_WIDTH/2; y=SC_HEIGHT/2;
  vg_bitmap_copyto(NULL,x,y,bmptext,0,0,0,0,RGB_FULL);
  vg_window_flush();
  sleep(3);

  /* free bitmap */
  vg_bitmap_free(bmptext);

  /* close window */
  vg_window_close();

  exit(0);
}
