/* tut-font2.c
  Give out a text language-dependend
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  char txt[128],buf[128];  // for the text
  const char * ptr;  // for the translated text
  int x,y;

  /* initialize vgagames, always pass argv[0] */
  // use default language (NULL): the language used in this program
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* set text */
  snprintf(txt,sizeof(txt),"This language is: %%s");

  /* draw text language-dependend */
  ptr=vg_get_textformat(txt);  // ptr points to the translated text or to txt
  snprintf(buf,sizeof(buf),ptr,vg_get_textformat("english"));
  x=(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2;
  y=(SC_HEIGHT-vg_font_height(NULL))/2;
  vg_draw_text(NULL,RGB_WHITE,x,y,buf,NULL,RGB_FULL);

  /* now flush window out to visible screen and wait 3 seconds */
  vg_window_flush();
  sleep(3);
  vg_bitmap_clear(NULL,RGB_BLACK);  // clear window

  /* call language menu of the VgaGames-system-menu */
  // you should change the language
  vg_menu_language();

  /* again draw text language-dependend */
  ptr=vg_get_textformat(txt);  // ptr points to the translated text or to txt
  snprintf(buf,sizeof(buf),ptr,vg_get_textformat("english"));
  x=(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2;
  y=(SC_HEIGHT-vg_font_height(NULL))/2;
  vg_draw_text(NULL,RGB_WHITE,x,y,buf,NULL,RGB_FULL);

  /* now flush window out to visible screen and wait 3 seconds */
  vg_window_flush();
  sleep(3);

  /* close window */
  vg_window_close();

  exit(0);
}
