#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <vgagames2.h>

#include "tut-network0.h"


int main(int argc,char ** argv) {
  char * arg0;  // for the name of the program
  int nr;  // for player-number
  int pl_min=2, pl_max=4;
  char serverport[]="1234", mbcastport[]="1235";

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}


  /* +++ start networking +++ */

  /* set network variables */
  if (set_variables() < 0) {vg_window_close(); exit(1);}

  // set number of players
  if (vg_nw_setplayer(pl_min,pl_max) < pl_min) {vg_window_close(); exit(1);}

  // start network-server, UDP, timeout connect=20, IPv4, timeout receiving=30
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,10,0,"Starting network-server ...",NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_startserver(PROTO_UDP,serverport,20,4,mbcastport,30) < 0) {
    vg_window_close();
    exit(1);
  }

  // the master may end this waiting with space-key
  if (vg_nw_waitforconnects() < 0) {vg_nw_close(); vg_window_close(); exit(1);}

  // get pointers for player-data
  for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player
    player_data[nr-1].xpos=(short *)vg_nw_getvar("xpos",nr);
    player_data[nr-1].ypos=(short *)vg_nw_getvar("ypos",nr);
  }

  // get pointers for common-block
  common_block.sillytext=(char *)vg_nw_getcommon("sillytext");

  // initialize values
  for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player
    player_data[nr-1].xpos[0]=SC_WIDTH/2;   // or any other x-position value
    player_data[nr-1].ypos[0]=SC_HEIGHT/2;  // or any other y-position value
  }
  snprintf(common_block.sillytext,common_block.textsize,"%s","No way out");

  // send initial packet
  vg_nw_sendinit();


  /* +++ game loop +++ */

  for (;;) {
    int alive,nr,x,y;
    vg_bitmap_clear(NULL,RGB_BLACK);  // clear window

    // move players

    alive=0;  // check for any living real player
    for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player

      if (vg_nw_isalive(nr)) {  // player is alive

        // save moving request in x and y
        x=y=0;
        if (nr==vg_nw_myplayer()) {  // master's player
          if (vg_key_update() < 0) {goto quitgame;}   // network closed
          if (vg_key_pressed(KEY_DCURS,LONGKEY)) {y=1;}   // down
          if (vg_key_pressed(KEY_UCURS,LONGKEY)) {y=-1;}  // up
          if (vg_key_pressed(KEY_LCURS,LONGKEY)) {x=-1;}  // left
          if (vg_key_pressed(KEY_RCURS,LONGKEY)) {x=1;}   // right
          if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {       // player tired
            vg_nw_setdead(nr);
            continue;  // next player
          }
          alive=1;

        } else if (nr >= vg_nw_virtualplayer()) {  // virtual players
          x=time(NULL)%3-1;  // very silly algorithm
          y=time(NULL)%3-1;  // very silly algorithm

        } else {  // client players
          if (vg_nw_recvkeys(nr)) {  // client has sent a request
            if (vg_nw_keypressed(KEY_DCURS,LONGKEY)) {y=1;}   // down
            if (vg_nw_keypressed(KEY_UCURS,LONGKEY)) {y=-1;}  // up
            if (vg_nw_keypressed(KEY_LCURS,LONGKEY)) {x=-1;}  // left
            if (vg_nw_keypressed(KEY_RCURS,LONGKEY)) {x=1;}   // right
          }
          alive=1;
        }

        // now move according to x and y
        player_data[nr-1].xpos[0]+=x;
        if (player_data[nr-1].xpos[0] < 0) {player_data[nr-1].xpos[0]=0;}
        if (player_data[nr-1].xpos[0] >= SC_WIDTH) {
          player_data[nr-1].xpos[0]=SC_WIDTH-1;
        }
        player_data[nr-1].ypos[0]+=y;
        if (player_data[nr-1].ypos[0] < 0) {player_data[nr-1].ypos[0]=0;}
        if (player_data[nr-1].ypos[0] >= SC_HEIGHT) {
          player_data[nr-1].ypos[0]=SC_HEIGHT-1;
        }

        // send player's data
        vg_nw_senddata(nr);
      }
    }
    if (alive==0) {break;}  // no living player

    // set silly text (common-block) and send it to network-server
    switch(time(NULL)%12) {
      case 0:
        snprintf(common_block.sillytext,common_block.textsize,"%s","No way out");
        break;
      case 4:
        snprintf(common_block.sillytext,common_block.textsize,"%s","Check your defaults");
        break;
      case 8:
        snprintf(common_block.sillytext,common_block.textsize,"%s","Medio tutissime ibis");
        break;
    }
    vg_nw_sendcommon();

    // draw players
    for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player
      if (vg_nw_isalive(nr)) {  // player is alive
        vg_draw_circle(NULL,player_data[nr-1].xpos[0],player_data[nr-1].ypos[0],5+nr*2,RGB_WHITE,0);
      }
    }

    // draw silly text
    vg_draw_text(NULL,RGB_WHITE,0,0,common_block.sillytext,NULL,RGB_TRANS);

    // do rest
    vg_window_flush();
    vg_wait_time(50);
  }  // end game-loop

quitgame:
  vg_nw_close();
  vg_window_close();
  exit(0);
} /* end main */
