#include <stdlib.h>
#include <sys/types.h>
#include <vgagames2.h>


struct {
  short * xpos;  // x-position
  short * ypos;  // y-position
} player_data[NW_MAXCLIENT];  // NW_MAXCLIENT is always save

struct {
  char * sillytext;  // array for silly text
  int textsize;      // set it later to 40
} common_block;


int set_variables(void) {
  // player-data
  if (vg_nw_setvar(NWVAR_SHORT,1,"xpos") < 1) {return(-1);}
  if (vg_nw_setvar(NWVAR_SHORT,1,"ypos") < 1) {return(-1);}

  // common-block
  common_block.textsize=40;
  if (vg_nw_setcommon(NWVAR_CHAR,common_block.textsize,"sillytext") < 1) {
    return(-1);
  }
  return(0);
}


void get_pointers(void) {
  // get pointers for player-data
  int nr;
  for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player
    player_data[nr-1].xpos=(short *)vg_nw_getvar("xpos",nr);
    player_data[nr-1].ypos=(short *)vg_nw_getvar("ypos",nr);
  }

  // get pointers for common-block
  common_block.sillytext=(char *)vg_nw_getcommon("sillytext");
}
