#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>

#include "tut-network0.h"


int main(int argc,char ** argv) {
  char * arg0;  // for the name of the program
  int nr;  // for player-number
  char serverport[]="1234", mbcastport[]="1235";

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}


  /* +++ start networking +++ */

  /* set network variables */
  if (set_variables() < 0) {vg_window_close(); exit(1);}

  /* connect and wait */
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,10,0,"Connecting to network-server ...",NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_connect(PROTO_UDP,NULL,serverport,mbcastport) < 0) {
    vg_window_close();
    exit(1);
  }

  if (vg_nw_waitforconnects() < 0) {vg_nw_close(); vg_window_close(); exit(1);}

  // get pointers for player-data
  for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player
    player_data[nr-1].xpos=(short *)vg_nw_getvar("xpos",nr);
    player_data[nr-1].ypos=(short *)vg_nw_getvar("ypos",nr);
  }

  // get pointers for common-block
  common_block.sillytext=(char *)vg_nw_getcommon("sillytext");

  // receive initial packet
  if (vg_nw_recvinit() < 0) {vg_nw_close(); vg_window_close(); exit(1);}


  /* +++ game loop +++ */

  for (;;) {
    int nr;
    vg_bitmap_clear(NULL,RGB_BLACK);  // clear window

    // get keystrokes and do network-transfer
    if (vg_key_update() < 0) {break;}  // network closed
    if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {  // player tired
      vg_nw_setdead(vg_nw_myplayer());
      break;
    }

    // draw players
    for (nr=1; nr <= vg_nw_maxplayer(); nr++) {  // for each player
      if (vg_nw_isalive(nr)) {  // player is alive
        vg_draw_circle(NULL,player_data[nr-1].xpos[0],player_data[nr-1].ypos[0],5+nr*2,RGB_WHITE,0);
      }
    }

    // draw silly text
    vg_draw_text(NULL,RGB_WHITE,0,0,common_block.sillytext,NULL,RGB_TRANS);

    // do rest
    vg_window_flush();
    vg_wait_time(50);
  }  // end game-loop

  vg_nw_close();
  vg_window_close();
  exit(0);
} /* end main */
