/* tut-network1.c
   sunnyboys moving around.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>

#include "tut-network1.h"

static int start_server(int,int);
static void init_values(int);
static int getkeys(int);


int main(int argc, char ** argv) {
  const int nop_from=4,nop_to=4;  // number of players: from and to
  char * arg0;  // for the name of the program
  bitmap * binfo;  // for info text
  int plno;  // for player index
  int rval=0;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create info bitmap */
  if ((binfo=vg_bitmap_createfromtext(RGB_WHITE,RGB_BLACK,2,0,"[Arrow keys]=Move, [Space]=End",NULL))==NULL) {
    vg_window_close();
    exit(1);
  }

  /* +++ start networking +++ */

  /* set network variables */
  if (set_variables() < 0) {vg_window_close(); exit(1);}

  /* start network-server and connect to it,
  ** pass the number of players we want to have
  */
  if (start_server(nop_from,nop_to) < 0) {vg_window_close(); exit(1);}

  /* get network pointers and create sunnyboys */
  if (get_pointers(vg_nw_maxplayer()) < 0) {vg_nw_close(); vg_window_close(); exit(1);}

  /* initialize values for network pointers */
  init_values(vg_nw_maxplayer());

  /* send initial packet to clients */
  vg_nw_sendinit();


  /* +++ game loop +++ */

  /* move your sunnyboy and the virtual sunnyboys,
  ** get moving requests from all other sunnyboys, move them,
  ** set actual data for each player into network-data and send it
  */

  for (;;) {
    /* clear window */
    vg_bitmap_clear(NULL,RGB_BLACK);

    /* draw info bitmap at the bottom */
    vg_bitmap_copyto(NULL,vg_bitmap_width(binfo)/2,SC_HEIGHT-vg_bitmap_height(binfo)/2,binfo,0,0,0,0,RGB_TRANS);

    /* go through all players */
    for (plno=1; plno <= vg_nw_maxplayer(); plno++) {

      /* get keystrokes and set pl_data[] */
      rval=getkeys(plno);
      if (rval<0) {break;}  /* network closed or end of game requested */

      /* draw sunnyboy, if it is alive */
      if (vg_nw_isalive(plno)) {  /* player is alive */
        vg_bitmap_copyto(NULL,pl_data[plno-1].xpos,pl_data[plno-1].ypos,pl_data[plno-1].sunboy,0,0,0,0,RGB_TRANS);
      } else if (plno==vg_nw_myplayer()) {  /* master is dead, draw it rotated */
        vg_bitmap_copyto(NULL,pl_data[plno-1].xpos,pl_data[plno-1].ypos,vg_bitmap_rotate(pl_data[plno-1].sunboy,180),0,0,0,0,RGB_TRANS);
      }
    }  // end for each player
    if (rval<0) {break;}  /* network closed or end of game requested */

    vg_window_flush();  /* flush all out to window */
    vg_wait_time(50);  /* loop delay */
  }  // end game loop

  vg_bitmap_free(binfo);
  vg_nw_close();
  vg_window_close();
  exit(0);
} /* end main */


static int start_server(int nop_from,int nop_to) {
/* start and make connection to server
** 1.+2.arg: number of players: at least and at most
*/
  char buf[64];  // for explaining text

  /* set the minimum and maximum number of players we want
  ** check return value, whether at least nop_from players are allowed
  */
  if (vg_nw_setplayer(nop_from,nop_to) < nop_from) {return(-1);}

  /* start network-server
  ** using UDP,
  ** timeout for connects 20 sec.,
  ** IPv4,
  ** timeout for not receiving any packet 30 sec.
  */
  snprintf(buf,sizeof(buf),"Starting network-server ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_startserver(PROTO_UDP,serverport,20,4,mbcastport,30)<0) {return(-1);}

  /* wait for all other connects */
  snprintf(buf,sizeof(buf),"Waiting for other players ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_waitforconnects()<0) {vg_nw_close(); return(-1);}

  return(0);
} /* end start_server */


static void init_values(int number_of_pl) {
/* master: set initial values for all players
** 1.arg: total number of players
*/
  int i1;
  /* set values for players */
  for (i1=1; i1 <= number_of_pl; i1++) {
    /* set initial x- and y-position */
    pl_data[i1-1].xpos=SC_WIDTH/2;
    pl_data[i1-1].ypos=SC_HEIGHT/2;

    /* set network variable: n_xypos[0]=ypos*SC_WIDTH+xpos */
    pl_data[i1-1].n_xypos[0]=(unsigned short)(pl_data[i1-1].ypos*SC_WIDTH+pl_data[i1-1].xpos);
  }

  /* set values for common-block: none */
} /* end init_values */


static int getkeys(int plno) {
/* get keystrokes (from keyboard or network or via an algorithm)
** and set pl_data[] (moving sunnyboy)
** 1.arg: number of a player
** return:  0=OK
**         -1=end of game requested or network closed
*/
  if (vg_nw_isalive(plno)) {  /* player is alive */
    int x,y;

    /* get sunnyboys moving request */
    x=y=0;
    if (plno==vg_nw_myplayer()) {
      /* your sunnyboy, move with keystrokes */
      if (vg_key_update()<0) {return(-1);}  /* network closed */

      if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {  // quit with space-key
        vg_nw_setdead(plno);  // set dead to inform network-server
        return(0);  // do not end the game (wait for the second keystroke)
      }
      /* save request values in x,y */
      if (vg_key_pressed(KEY_DCURS,LONGKEY)) {y=1;}  /* down */
      if (vg_key_pressed(KEY_UCURS,LONGKEY)) {y=-1;}  /* up */
      if (vg_key_pressed(KEY_LCURS,LONGKEY)) {x=-1;}  /* left */
      if (vg_key_pressed(KEY_RCURS,LONGKEY)) {x=1;}  /* right */

    } else if (plno >= vg_nw_virtualplayer()) {
      /* virtual players, move with a simple algorithmus */
      if (pl_data[plno-1].keycount==0) {
        pl_data[plno-1].keyno=ZUFALL(4);  /* which arrow key */
        pl_data[plno-1].keycount=ZUFALL(25)+5;  /* how long pressed */
      }
      pl_data[plno-1].keycount--;
      /* save request values in x,y */
      switch (pl_data[plno-1].keyno) {
        case 0: y=1; break;
        case 1: y=-1; break;
        case 2: x=-1; break;
        case 3: x=1; break;
      }

    } else {
      /* sunnyboys of other clients,
         save request values in x,y
      */
      if (vg_nw_recvkeys(plno)) {  /* client has sent a request */
        if (vg_nw_keypressed(KEY_DCURS,LONGKEY)) {y=1;}  /* down */
        if (vg_nw_keypressed(KEY_UCURS,LONGKEY)) {y=-1;}  /* up */
        if (vg_nw_keypressed(KEY_LCURS,LONGKEY)) {x=-1;}  /* left */
        if (vg_nw_keypressed(KEY_RCURS,LONGKEY)) {x=1;}  /* right */
      }
    }

    /* now really move sunnyboy, checking boundaries before */
    if (y==1) {  /* down request */
      int bound=SC_HEIGHT-vg_bitmap_height(pl_data[plno-1].sunboy)/2;
      if (++pl_data[plno-1].ypos > bound) {
        pl_data[plno-1].ypos=bound;
        pl_data[plno-1].keycount=0;
      }
    } else if (y==-1) {  /* up request */
      int bound=vg_bitmap_height(pl_data[plno-1].sunboy)/2;
      if (--pl_data[plno-1].ypos < bound) {
        pl_data[plno-1].ypos=bound;
        pl_data[plno-1].keycount=0;
      }
    }
    if (x==-1) {  /* left request */
      int bound=vg_bitmap_width(pl_data[plno-1].sunboy)/2;
      if (--pl_data[plno-1].xpos < bound) {
        pl_data[plno-1].xpos=bound;
        pl_data[plno-1].keycount=0;
      }
    } else if (x==1) {  /* right request */
      int bound=SC_WIDTH-vg_bitmap_width(pl_data[plno-1].sunboy)/2;
      if (++pl_data[plno-1].xpos > bound) {
        pl_data[plno-1].xpos=bound;
        pl_data[plno-1].keycount=0;
      }
    }

    /* update values of network pointers and send data */
    pl_data[plno-1].n_xypos[0]=(unsigned short)(pl_data[plno-1].ypos*SC_WIDTH+pl_data[plno-1].xpos);
    vg_nw_senddata(plno);

  } else {  /* player is not alive */
    if (plno==vg_nw_myplayer()) {  /* your sunnyboy */
      if (vg_key_update()<0) {return(-1);}  /* network closed */
      if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {  // quit with space-key
        return(-1);
      }
    }
  }
  return(0);
} /* end getkeys */
