/* tut-network1
   sunnyboys moving around.
*/

#include <stdlib.h>
#include <sys/types.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


/* random number from 0 upto Z-1 */
#define ZUFALL(Z)  ((int)((float)(Z)*rand()/(RAND_MAX+1.0)))

static char serverport[]="2222";  // port of network-server
static char mbcastport[]="2223";  // broadcast/multicast port to get server-ip


/* struct for each player,
** contains players' values and their translation into network variables.
** If we don't know how many players, we assume the maximum: NW_MAXCLIENT
*/
struct {
  /* player's values */
  bitmap * sunboy;     /* players sunnyboy */
  int xpos,ypos;       /* position of sunnyboy */
  int keyno,keycount;  /* only for virtual player's moving algorithmus */

  /* network pointers */
  unsigned short * n_xypos;  /* pointer to network-x/y-position */
} pl_data[NW_MAXCLIENT];


/* functions for master and clients to set/get network pointers */

static int set_variables(void);
static int get_pointers(int);

static int set_variables() {
  memset(pl_data,0,sizeof(pl_data));
  /* define network variables: pl_data[].n_xypos[0] */
  if (vg_nw_setvar(NWVAR_USHORT,1,"xypos")<1) {return(-1);}

  return(0);
} /* end set_variables */


static int get_pointers(int number_of_pl) {
/* 1.arg: total number of players */
  int i1;
  /* selection of colors for sunnyboys */
  int sunny_color[8]={CL_RED, CL_YELLOW, CL_GREEN, CL_BLUE, CL_VIOLET, CL_PINK, CL_ORANGE, CL_TURQUOISE};

  memset(pl_data,0,sizeof(pl_data));

  /* get network pointers */
  for (i1=1; i1 <= number_of_pl; i1++) {  // for each player
    pl_data[i1-1].n_xypos=(unsigned short *)vg_nw_getvar("xypos",i1);

    /* create sunnyboy of player */
    pl_data[i1-1].sunboy=create_sunnyboy(vg_color_index(sunny_color[(i1-1)%8],100));
    if (pl_data[i1-1].sunboy==NULL) {return(-1);}
  }
  return(0);
} /* end get_pointers */
