/* tut-network2_client.c
   client program for tut-network2
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>

#include "tut-network2.h"

static int connect_server(void);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * binfo;  // for info text
  int plno;  // for player index

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create info bitmap */
  if ((binfo=vg_bitmap_createfromtext(RGB_WHITE,RGB_BLACK,2,0,"[Arrow keys]=Move, [Space]=End",NULL))==NULL) {
    vg_nw_close();
    vg_window_close();
    exit(1);
  }

  /* +++ start networking +++ */

  /* set network variables */
  if (set_variables() < 0) {vg_window_close(); exit(1);}

  /* connect to network-server */
  if (connect_server() < 0) {vg_window_close(); exit(1);}

  /* get network pointers and create sunnyboys */
  if (get_pointers(vg_nw_maxplayer()) < 0) {vg_nw_close(); vg_window_close(); exit(1);}

  /* receive initial packet from master */
  if (vg_nw_recvinit()<0) {vg_nw_close(); vg_window_close(); exit(1);}


  /* +++ game loop +++ */

  /* send your moving requests for your sunnyboy to master,
  ** draw all sunnyboys according to received network-data
  */

  for (;;) {
    /* clear window */
    vg_bitmap_clear(NULL,RGB_BLACK);

    /* draw info bitmap at the bottom */
    vg_bitmap_copyto(NULL,vg_bitmap_width(binfo)/2,SC_HEIGHT-vg_bitmap_height(binfo)/2,binfo,0,0,0,0,RGB_TRANS);

    // get keystrokes and do network-transfer
    if (vg_key_update() < 0) {break;}  // network closed
    if (vg_key_pressed(KEY_SPACE,SHORTKEY)) {  // player wants to quit
      vg_nw_setdead(vg_nw_myplayer());
      break;
    }

    /* get sunnyboys position, decompressing value of network-variable n_xypos */
    for (plno=1; plno <= vg_nw_maxplayer(); plno++) {
      pl_data[plno-1].xpos=pl_data[plno-1].n_xypos[0]%SC_WIDTH;
      pl_data[plno-1].ypos=pl_data[plno-1].n_xypos[0]/SC_WIDTH;
    }

    /* go through all players */
    for (plno=1; plno <= vg_nw_maxplayer(); plno++) {

      /* draw sunnyboy, if it is alive */
      if (vg_nw_isalive(plno)) {  /* player is alive */
        vg_bitmap_copyto(NULL,pl_data[plno-1].xpos,pl_data[plno-1].ypos,pl_data[plno-1].sunboy,0,0,0,0,RGB_TRANS);
      }
    }  // end for each player

    /* give out common date */
    vg_draw_text(NULL,RGB_WHITE,0,0,pl_comm.date,NULL,RGB_TRANS);

    vg_window_flush();  /* flush all out to window */
    vg_wait_time(50);  /* loop delay */
  }  // end game loop

  vg_bitmap_free(binfo);
  vg_nw_close();
  vg_window_close();
  exit(0);
} /* end main */


static int connect_server() {
/* make connection to server */
  char buf[64];  // for explaining text

  /* connect to network-server via broadcast/multicast */
  snprintf(buf,sizeof(buf),"Connecting to network-server ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_connect(PROTO_UDP,NULL,serverport,mbcastport) < 0) {return(-1);}

  /* wait for all other connects */
  snprintf(buf,sizeof(buf),"Waiting for other players ...");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  if (vg_nw_waitforconnects()<0) {vg_nw_close(); return(-1);}

  return(0);
} /* end connect_server */
