/* tut-sound1.c
   Using basic sound functions.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  char buf[64];  // for explaining text
  int lastvol;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* start soundserver */
  if (vg_sound_startserver(0,0,NULL) < 0) {vg_window_close(); exit(1);}

  /* load midi-file attaching it to nickname "s-music" using orignal volume */
  vg_sound_attach("sound/phatjail.mid","s-music",100);

  /* start midi-file becoming louder for 5 seconds up to its normal volume */
  snprintf(buf,sizeof(buf),"Beginning to play music");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  vg_sound_play("s-music",5,1);
  sleep(5);
  snprintf(buf,sizeof(buf),"Music is playing");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  sleep(5);

  /* pausing midi-file */
  snprintf(buf,sizeof(buf),"Pausing music");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  vg_sound_paus("s-music");
  sleep(3);

  /* continuing midi-file */
  snprintf(buf,sizeof(buf),"Continuing music");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  vg_sound_cont("s-music");
  sleep(5);

  /* changing main volume */
  snprintf(buf,sizeof(buf),"Changing main volume");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  lastvol=vg_sound_volm("0",-1);  /* get current volume */
  vg_sound_volm("0",lastvol+10);  /* add 10 to current volume */
  sleep(3);

  /* stopping music */
  snprintf(buf,sizeof(buf),"Stopping music");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  vg_sound_stop("s-music",5);
  sleep(5);
  snprintf(buf,sizeof(buf),"Music stopped");
  vg_bitmap_clear(NULL,RGB_BLACK);
  vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
  vg_window_flush();
  sleep(3);

  /* end soundserver and close window */
  vg_sound_endserver();
  vg_window_close();

  exit(0);
}
