/* tut-sound3.c
   Grouping two sound files together
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  char buf[64];  // for explaining text

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* start soundserver */
  if (vg_sound_startserver(0,0,NULL) < 0) {vg_window_close(); exit(1);}

  /* load the two midi-files */
  vg_sound_attach("sound/phatjail.mid","s-phatjail",100);
  vg_sound_attach("sound/folshop.mid","s-folshop",100);

  /* group the two midi-files together to a group named "g-midi" */
  vg_sound_gadd("g-midi","s-folshop");
  vg_sound_gadd("g-midi","s-phatjail");

  /* give the group a volumename */
  vg_sound_volumename("g-midi","Midi files");

  /* play "s-folshop" */
  vg_sound_play("s-folshop",0,1);

  for (;;) {
    snprintf(buf,sizeof(buf),"Return: Volume menu, Space: End");
    vg_bitmap_clear(NULL,RGB_BLACK);
    vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(buf)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,buf,NULL,RGB_FULL);
    vg_window_flush();

    /* end loop if SPACE pressed */
    vg_key_update();
    if (vg_key_pressed(KEY_SPACE, SHORTKEY)) {break;}

    /* call submenu "volume" of VgaGames-system-menu */
    if (vg_key_pressed(KEY_ENTER, SHORTKEY)) {vg_menu_volume();}

    vg_wait_time(70);
  }

  /* end soundserver and close window */
  vg_sound_endserver();
  vg_window_close();

  exit(0);
}
