/* tut-sprite1.c
   Create a sprite with a sunnyboy, which zoomes in and out,
   then end the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


/* function to return a created sunnyboy bitmap */
extern bitmap * create_sunnyboy(int);


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  bitmap * sunboy;  // for the sunnyboy
  sprite * sunsprite;  // sunnyboy sprite
  double d1;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* create a yellow sunnyboy */
  sunboy=create_sunnyboy(vg_color_index(CL_YELLOW,100));
  if (sunboy==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* create a new new sprite */
  sunsprite=vg_sprite_createnew();
  if (sunsprite==NULL) {  // error
    vg_window_close();
    exit(1);
  }

  /* add zoomed sunnyboys to sprite */
  vg_sprite_add(sunsprite,vg_bitmap_zoom(sunboy,1.0,1.0),18,NULL,0);
  for (d1=1.1; d1<2.0; d1+=0.1) {  /* becoming larger */
    vg_sprite_add(sunsprite,vg_bitmap_zoom(sunboy,d1,d1),3,NULL,0);
  }
  vg_sprite_add(sunsprite,vg_bitmap_zoom(sunboy,d1,d1),18,NULL,0);
  for (; d1>1.0; d1-=0.1) {  /* becoming smaller */
    vg_sprite_add(sunsprite,vg_bitmap_zoom(sunboy,d1,d1),3,NULL,0);
  }
  vg_sprite_add(sunsprite,vg_bitmap_zoom(sunboy,1.0,1.0),18,NULL,0);

  /* free sunnyboy */
  vg_bitmap_free(sunboy);

  /* give out sprite one time */
  while ((sunboy=vg_sprite_getnext(sunsprite))!=NULL) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    vg_bitmap_copyto(NULL,SC_WIDTH/2,SC_HEIGHT/2,sunboy,0,0,0,0,RGB_FULL);
    vg_window_flush();
    vg_wait_time(50);
  }

  /* free sprite */
  vg_sprite_free(sunsprite);

  /* close window */
  vg_window_close();

  exit(0);
}
