/* tut-window0.c
   Press ESCAPE-key to get into the VgaGames-system-menu.
   The program ends after 5 seconds inactivity, unless you are in the menu.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  char text[]="Press ESCAPE-key";
  int i1;

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* program loop */
  for (i1=0; i1 < 5000; i1+=50) {

    /* clear the window (not visible unless called vg_window_flush()) */
    vg_bitmap_clear(NULL, RGB_BLACK);

    /* give out message */
    vg_draw_text(NULL,RGB_WHITE,(SC_WIDTH-strlen(text)*vg_font_width(NULL))/2,(SC_HEIGHT-vg_font_height(NULL))/2,text,NULL,RGB_FULL);

    /* now flush window out to visible screen */
    vg_window_flush();

    /* update key and mouse events, this automatically checks for ESCAPE */
    vg_key_update();

    /* wait a little time up to 50 milliseconds */
    vg_wait_time(50);
  }

  /* close window */
  vg_window_close();

  exit(0);
}
