/* tut-window1.c
   Move a white pixel with the arrow keys (cursor keys).
   The arrow keys left and right use LONGKEY,
   the arrow keys up and down use SHORTKEY.
   End the program with space key.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program
  int x,y;  // for position of white pixel

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* to begin set pixel into midth of window */
  x=SC_WIDTH/2;   // SC_WIDTH is width of window=320 pixels
  y=SC_HEIGHT/2;  // SC_HEIGHT is height of window=200 pixels

  /* program loop */
  for (;;) {

    /* clear the window (not visible unless called vg_window_flush()) */
    vg_bitmap_clear(NULL, RGB_BLACK);

    /* update key and mouse events */
    vg_key_update();

    /* move pixel */
    if (vg_key_pressed(KEY_RCURS, LONGKEY)) {
      if (++x >= SC_WIDTH) {x=SC_WIDTH-1;}
    }
    if (vg_key_pressed(KEY_LCURS, LONGKEY)) {
      if (--x < 0) {x=0;}
    }
    if (vg_key_pressed(KEY_UCURS, SHORTKEY)) {
      if (--y < 0) {y=0;}
    }
    if (vg_key_pressed(KEY_DCURS, SHORTKEY)) {
      if (++y >= SC_HEIGHT) {y=SC_HEIGHT-1;}
    }

    /* draw the pixel */
    vg_draw_pixel(NULL,x,y,RGB_WHITE);

    /* give an info */
    vg_draw_text(NULL,RGB_WHITE,0,SC_HEIGHT-vg_font_height(NULL),"Arrow keys=move, space=end",NULL,RGB_FULL);

    /* now flush window out to visible screen */
    vg_window_flush();

    /* check for space key to end the program */
    if (vg_key_pressed(KEY_SPACE, SHORTKEY)) {
      break;
    }

    /* wait a little time up to 70 milliseconds */
    vg_wait_time(70);
  }

  /* close window */
  vg_window_close();

  exit(0);
}
