/* tut-window2.c
   At the position of the mouse-pointer a single white pixel is drawn.
   When moving the mouse, the pixel also moves.
   When moving the mouse with left mouse-button pressed, a line is drawn
   from the position where the button was pressed to the actual position.
   End the program with right mouse-button.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames2.h>


int main(int argc, char ** argv) {
  char * arg0;  // for the name of the program

  /* initialize vgagames, always pass argv[0] */
  if (vg_init_vgagames(argv[0],0,NULL) < 0) {exit(1);}

  /* open window */
  if ((arg0=strrchr(argv[0],'/'))==NULL) {arg0=argv[0];} else {arg0++;}
  if (vg_window_open(arg0,0,0) < 0) {exit(1);}

  /* check for mouse */
  if (!vg_mouse_found()) {
    fprintf(stderr,"Cannot find a mouse\n");
    vg_window_close();  // close window
    exit(1);
  }

  /* program loop */
  for (;;) {

    /* update key and mouse events */
    vg_key_update();

    /* clear the window (not visible unless called vg_window_flush()) */
    vg_bitmap_clear(NULL, RGB_BLACK);

    if (vg_mouse_x() >= 0) {  // mouse inside the window
      static int press_x=0, press_y=0;  // where mouse-button was pressed
      int x,y;
      x=vg_mouse_x();  // get x-position of mouse
      y=vg_mouse_y();  // get y-position of mouse

      /* check whether left mouse-button is pressed */
      if (vg_mouse_pressed(MOUSE_LEFT, LONGKEY)) {
        /* draw a line */
        vg_draw_line(NULL,press_x,press_y,x,y,RGB_WHITE);
      } else {
        /* draw the pixel */
        vg_draw_pixel(NULL,x,y,RGB_WHITE);
        press_x=x;  // remember mouse x-position
        press_y=y;  // remember mouse y-position
      }

      /* give an info */
      vg_draw_text(NULL,RGB_WHITE,0,SC_HEIGHT-vg_font_height(NULL),"mouse left button=line, right button=end",NULL,RGB_FULL);

      /* now flush window out to visible screen */
      vg_window_flush();

      /* check for right mouse-button to end the program,
         instead of using SHORTKEY here we also could have used LONGKEY
      */
      if (vg_mouse_pressed(MOUSE_RIGHT, SHORTKEY)) {
        break;
      }
    }

    /* wait a little time up to 70 milliseconds */
    vg_wait_time(70);
  }

  /* close window */
  vg_window_close();

  exit(0);
}
