/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <net/if.h>
#include "config.h"
#include "vgagames.h"
#include "nw_support.h"
#include "nw_mbcast.h"
#include "nw_rdwr.h"


static volatile sig_atomic_t sig_alrm=0;
static int inetv=0;
static char argv0[]="call_server";

int call_server(const char *,const char *,const char *);
static void conn_serv(int [8],size_t,int,int,char *,size_t);
static void do_alrm(int);


int call_server(const char * anzp,const char * vanzp,const char * service) {
/* Wait for connections
** parameters: 
**  - number of players to wait for connection (from "1" to "8")
**  - number of virtual players included in number of players
**  - portnumber listening to
*/
  const int altm=90;  /* alarm time for accept */
  const int bcklg=SOMAXCONN;
  const int on=1;
  socklen_t addr_len,stlen;
  int anz,vanz,sfd,cfd[8],n1,n2,s1,master;
  char serv[8],buf[256],* shmem;
  size_t stsz,shsz;
  struct addrinfo adi0,* adi1,* adi2;
  struct sockaddr * ska;

  anz=atoi(anzp);
  vanz=atoi(vanzp);
  if ((anz<1) || (anz>8) || (vanz<0) || (vanz>=anz)) {fprintf(stderr,"%s: Wrong number of players\n",argv0); return(-1);}
  strncpy(serv,service,sizeof(serv)-1);
  serv[sizeof(serv)-1]='\0';
  if ((atoi(serv)<1) || (atoi(serv)>65536)) {
    fprintf(stderr,"%s: Wrong port\n",argv0);
    return(-1);
  }

  /* open listening socket */
  memset(&adi0,0,sizeof(struct addrinfo));
  adi0.ai_flags=AI_PASSIVE;
  adi0.ai_socktype=SOCK_STREAM;
  adi0.ai_family=AF_INET;
  strcpy(buf,"0.0.0.0");
  if ((n1=getaddrinfo(buf,serv,&adi0,&adi1))!=0) {
#ifdef AF_INET6
    adi0.ai_family=AF_INET6;
    strcpy(buf,"0::0");
    if ((n1=getaddrinfo(buf,serv,&adi0,&adi1))!=0) {
#endif
      fprintf(stderr,"%s: Socket error: %s\n",argv0,gai_strerror(n1));
      return(-1);
#ifdef AF_INET6
    }
#endif
  }
  adi2=adi1;
  do {
    sfd=socket(adi1->ai_family,adi1->ai_socktype,adi1->ai_protocol);
    if (sfd<0) {continue;}
    if (setsockopt(sfd,SOL_SOCKET,SO_REUSEADDR,&on,sizeof(on))<0) {
      fprintf(stderr,"%s: Setsockopt error\n",argv0);
      freeaddrinfo(adi2);
      return(-1);
    }
    if (bind(sfd,adi1->ai_addr,adi1->ai_addrlen)==0) {break;}
    close(sfd);
  } while ((adi1=adi1->ai_next)!=NULL);
  if (adi1==NULL) {
    fprintf(stderr,"%s: Cannot get socket\n",argv0);
    freeaddrinfo(adi2);
    return(-1);
  }
  if (listen(sfd,bcklg)<0) {
    fprintf(stderr,"%s: Cannot listen at (%s)\n",argv0,serv);
    freeaddrinfo(adi2);
    return(-1);
  }
  addr_len=adi1->ai_addrlen;
  inetv=adi1->ai_addr->sa_family;
  freeaddrinfo(adi2);
  if ((ska=malloc(addr_len))==NULL) {
    fprintf(stderr,"%s: Cannot allocate memory\n",argv0);
    close(sfd);
    return(-1);
  }
  /* start broadcast/multicast server */
  if (mbcast_server(serv,altm,4,1)<0) {
    close(sfd);
    free(ska);
    return(-1);
  }
  /* wait for connections */
  for (n1=0;n1<8;n1++) {cfd[n1]=-1;}
  stsz=0;
  n1=vanz+1;
  while (anz-vanz>0) {
    stlen=addr_len;
    alarm(altm);
    s1=accept(sfd,ska,&stlen);
    alarm(0);
    if (s1<0) {
      fprintf(stderr,"%s: Accept error\n",argv0);
      free(ska);
      for (n2=0;n2<8;n2++) {if (cfd[n2]>-1) {close(cfd[n2]);}}
      close(sfd);
      return(-1);
    }
    if (readn(s1,buf,5)!=5) {  /* read data size + master identification */
      free(ska);
      for (n2=0;n2<8;n2++) {if (cfd[n2]>-1) {close(cfd[n2]);}}
      close(sfd);
      return(-1);
    }
    if (buf[4]=='1') {master=1;} else {master=0;}
    buf[4]='\0';
    if (stsz==0) {stsz=atoi(buf);}
    if (atoi(buf)!=(int)stsz) {
      fprintf(stderr,"%s: Data size error\n",argv0);
      free(ska);
      for (n2=0;n2<8;n2++) {if (cfd[n2]>-1) {close(cfd[n2]);}}
      close(sfd);
      return(-1);
    }
    if (master) {cfd[0]=s1;} else {cfd[n1++]=s1;}
    anz--;
  }
  free(ska);
  close(sfd);
  /* allocate memory */
  shsz=(1+8)*stsz;
  if ((shmem=calloc(sizeof(char),shsz))==NULL) {
    fprintf(stderr,"%s: Cannot allocate memory\n",argv0);
    for (n2=0;n2<8;n2++) {if (cfd[n2]>-1) {close(cfd[n2]);}}
    return(-1);
  }
  /* reply to clients */
  anz=atoi(anzp);
  for (n1=1;n1<=anz;n1++) {
    if (cfd[n1-1]>-1) {
      snprintf(buf,sizeof(buf),"%d%d",anz,n1);
      writen(cfd[n1-1],buf,2);
    }
  }
  /* act as connected server */
  conn_serv(cfd,stsz,anz,vanz,shmem,shsz);
  free(shmem);
  return(0);
} /* Ende call_server */


static void conn_serv(int cfd[8],size_t stsz,int anz,int vanz,char * shmem,size_t shsz) {
/* acting as synchronisized connected server:
** args: socket descriptor field, data size, number of players (1-8),
**       virtual number of players, allocated memory, allocated memory size
** allocated memory:
**                   stsz * databytes for computerplayer
**                   stsz * databytes for player 1
**                   stsz * databytes for player 2
**                   ...
**                   stsz * databytes for player 8
*/
#undef __VGN_LAZY
  const int altm=5;  /* alarm time */
  const int rnr=(1+anz)*stsz;
  int i1,erg,manz;
  char * ptr;
  struct sigaction sa;
  memset(&sa,0,sizeof(sa));
  sa.sa_handler=do_alrm;
  sigaction(SIGALRM,&sa,NULL);
  manz=anz-vanz;
  while (manz>0) {
    ptr=shmem;
    if (cfd[0]>-1) {  /* master */
      alarm(altm);
      erg=readn(cfd[0],ptr,stsz*(1+1+vanz));
      alarm(0);
      if (erg!=(int)(stsz*(1+1+vanz))) {
        close(cfd[0]);
        cfd[0]=-1;
        memset(ptr,0,stsz*(1+1+vanz));
        manz--;
      }
#ifdef __VGN_LAZY
      else {writen(cfd[0],shmem,rnr);}
#endif
    }
    ptr+=stsz*(1+1+vanz);
    for (i1=vanz+2;i1<=anz;i1++) {
      if (cfd[i1-1]>-1) {
        alarm(altm);
        erg=readn(cfd[i1-1],ptr,stsz);
        alarm(0);
        if (erg!=(int)stsz) {
          close(cfd[i1-1]);
          cfd[i1-1]=-1;
          memset(ptr,0,stsz);
          manz--;
        }
#ifdef __VGN_LAZY
        else {writen(cfd[i1-1],shmem,rnr);}
#endif
      }
      ptr+=stsz;
    }
#ifndef __VGN_LAZY
    if (cfd[0]>-1) {writen(cfd[0],shmem,rnr);}
    for (i1=vanz+2;i1<=anz;i1++) {
      if (cfd[i1-1]>-1) {writen(cfd[i1-1],shmem,rnr);}
    }
#endif
  }
} /* Ende conn_serv */


static void do_alrm(int signum) {
  sig_alrm=1;
} /* Ende do_alrm */
