#!/bin/sh

version=199

# check echo
ECHO="echo"; ECHOSTRIP="\c"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && ECHO="echo -e"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && { ECHO="echo -n"; ECHOSTRIP=""; }

if test "$1" = ""
then
  echo "\"$0\": Config script for vgagames-compat library"
  exit 1
fi


para1=$1


# *** compat tests ***
if test "$2" = ""
then
  if test "$para1" = "vga"
  then
    exit 0
  elif test "$para1" = "vgl"
  then
    exit 0
  elif test "$para1" = "x"
  then
    exit 0
  fi
else
  if test "$para1" = "vga" || test "$para1" = "vgl"
  then
    para1="-cons"
  elif test "$para1" = "x"
  then
    para1="-x"
  fi
fi
if test "$para1" = "-win"
then
  para1="-x"
fi
if test "$para1" = "wave"
then
  echo "Not supported"
  exit 1
fi


# *** give out version number ***
if test "$para1" = "-v"
then
  echo $version
  exit 0
fi


# *** for compilation string ***
if test "$2" = ""
then
  exit 0
fi

if test "$para1" = "-cons" || test "$para1" = "-x"
then
  `dirname $0`/vgag2-config --cflags
  $ECHO "$2 $ECHOSTRIP"
  $ECHO " -lvgagames $ECHOSTRIP"
  `dirname $0`/vgag2-config --libs
  exit 0
fi

# *** look for midi-to-wave program or convert midi to wave ***
if test "$para1" = "wave-midi" || test "$para1" = "wave-mp3"
then
  echo "Not supported"
  exit 1
fi

exit 1
