/* Version 1.99
   Copyright (C) 2000-2007 Kurt Nienhaus */

#ifndef VGAGAMES_H_
#define VGAGAMES_H_

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern char errmsg[2048];  /* string for error message */

#include <sys/types.h>

#define SC_WIDTH 320
#define SC_HEIGHT 200

/* +++ vgagames-properties +++ */
extern struct w_mode {  /* properties of opened window */
  int isset;
  int videolib;
#define VIDEOLIB_X11     1
#define VIDEOLIB_SVGALIB 2
#define VIDEOLIB_VGL     3
#define VIDEOLIB_MAX     3  /* highest number of VIDEOLIB_* */
  struct {
    int scale;
#define VGAWINDOW_1          1
#define VGAWINDOW_2          2
#define VGAWINDOW_3          4
    int full;
#define VGAWINDOW_FULL       8
    int noswitch;
#define VGAWINDOW_NOSWITCH   16
    int directdraw;
#define VGAWINDOW_DIRECTDRAW 32
    /* internal use */
    int modenr,modemax;
    int modewidth,modeheight;
  } vlb[VIDEOLIB_MAX+1];
} window_mode;
extern struct s_mode {  /* properties of sound */
  int frg_anz;
  int frg_sz;
#define VOLUME_MAXNO 4
  int vol[VOLUME_MAXNO+1];
} sound_mode;
#define INITVGA_NOFILE 1  /* don't read vgagames-properties file */


/* +++ key and mouse +++ */
#define KEYS_INDEX 70   /* number of keys defined */
#define KEY_0           0    /* 0 */
#define KEY_1           1    /* 1 */
#define KEY_2           2    /* 2 */
#define KEY_3           3    /* 3 */
#define KEY_4           4    /* 4 */
#define KEY_5           5    /* 5 */
#define KEY_6           6    /* 6 */
#define KEY_7           7    /* 7 */
#define KEY_8           8    /* 8 */
#define KEY_9           9    /* 9 */
#define KEY_A           10   /* A */
#define KEY_B           11   /* B */
#define KEY_C           12   /* C */
#define KEY_D           13   /* D */
#define KEY_E           14   /* E */
#define KEY_F           15   /* F */
#define KEY_G           16   /* G */
#define KEY_H           17   /* H */
#define KEY_I           18   /* I */
#define KEY_J           19   /* J */
#define KEY_K           20   /* K */
#define KEY_L           21   /* L */
#define KEY_M           22   /* M */
#define KEY_N           23   /* N */
#define KEY_O           24   /* O */
#define KEY_P           25   /* P */
#define KEY_Q           26   /* Q */
#define KEY_R           27   /* R */
#define KEY_S           28   /* S */
#define KEY_T           29   /* T */
#define KEY_U           30   /* U */
#define KEY_V           31   /* V */
#define KEY_W           32   /* W */
#define KEY_X           33   /* X */
#define KEY_Y           34   /* Y */
#define KEY_Z           35   /* Z */
#define KEY_KP_0        36   /* Keypad 0 */
#define KEY_KP_1        37   /* Keypad 1 */
#define KEY_KP_2        38   /* Keypad 2 */
#define KEY_KP_3        39   /* Keypad 3 */
#define KEY_KP_4        40   /* Keypad 4 */
#define KEY_KP_5        41   /* Keypad 5 */
#define KEY_KP_6        42   /* Keypad 6 */
#define KEY_KP_7        43   /* Keypad 7 */
#define KEY_KP_8        44   /* Keypad 8 */
#define KEY_KP_9        45   /* Keypad 9 */
#define KEY_TAB         46   /* Tabulator */
#define KEY_RCTRL       47   /* Right Control */
#define KEY_LCTRL       48   /* Left Control */
#define KEY_RALT        49   /* Right Alt */
#define KEY_LALT        50   /* Left Alt */
#define KEY_SPACE       51   /* Space */
#define KEY_ENTER       52   /* Return */
#define KEY_BSP         53   /* Backspace */
#define KEY_RCURS       54   /* Right Cursor */
#define KEY_LCURS       55   /* Left Cursor */
#define KEY_UCURS       56   /* Up Cursor */
#define KEY_DCURS       57   /* Down Cursor */
#define KEY_F1          58   /* F1 */
#define KEY_F2          59   /* F2 */
#define KEY_F3          60   /* F3 */
#define KEY_F4          61   /* F4 */
#define KEY_F5          62   /* F5 */
#define KEY_F6          63   /* F6 */
#define KEY_F7          64   /* F7 */
#define KEY_F8          65   /* F8 */
#define KEY_F9          66   /* F9 */
#define KEY_F10         67   /* F10 */
#define KEY_F11         68   /* F11 */
#define KEY_F12         69   /* F12 */
#define LONGKEY  1
#define SHORTKEY 2

#define KEY_ESC         69   /* not supported: Escape */
#define KEY_RSHIFT      69   /* not supported: Right Shift */
#define KEY_LSHIFT      69   /* not supported: Left Shift */
#define SHORT_KEY SHORTKEY
#define LONG_KEY  LONGKEY
extern int _keyart[KEYS_INDEX];
#define CLEAR_KEYS      {int _i; for (_i=0;_i<KEYS_INDEX;_i++) {_keyart[_i]=0;}}
#define ADD_KEYS(A,B)   if (((A)>=0) && ((A)<KEYS_INDEX)) {_keyart[(A)]=(B);}
#define IS_KEYS(A)      (_keyart[(A)]>0?vg_key_pressed((A),_keyart[(A)]):0)
#define SAVE_KEYS(A)    if (((A)=malloc(sizeof(int)*(KEYS_INDEX)))!=NULL) {memmove((A),_keyart,sizeof(_keyart));}
#define RESTORE_KEYS(A) if ((A)!=NULL) {memmove(_keyart,(A),sizeof(_keyart)); free(A);}

#define MOUSE_LEFT   1
#define MOUSE_MIDDLE 2
#define MOUSE_RIGHT  3

#define MOUSE_FOUND    vg_mouse_found()
#define MOUSE_X        vg_mouse_x()
#define MOUSE_Y        vg_mouse_y()
#define IS_MOUSELEFT   vg_mouse_pressed(MOUSE_LEFT,SHORTKEY)
#define IS_MOUSERIGHT  vg_mouse_pressed(MOUSE_RIGHT,SHORTKEY)
#define IS_MOUSEMIDDLE vg_mouse_pressed(MOUSE_MIDDLE,SHORTKEY)


/* +++ colors +++ */
#define COLOR_MAX   18  /* number of colors defined */
#define CL_RED             1
#define CL_REDORANGE       2
#define CL_ORANGE          3
#define CL_YELLOWORANGE    4
#define CL_YELLOW          5
#define CL_YELLOWGREEN     6
#define CL_GREEN           7
#define CL_TURQUOISEGREEN  8
#define CL_TURQUOISE       9
#define CL_TURQUOISEBLUE   10
#define CL_BLUE            11
#define CL_BLUEVIOLET      12
#define CL_VIOLET          13
#define CL_REDVIOLET       14
#define CL_PINK            15
#define CL_BROWN           16
#define CL_WHITE           17
#define CL_BLACK           18

#define RGB256  "rgb256.clm"
#define GREY256 "grey256.clm"

#define VGAWINDOW_4  VGAWINDOW_3


/* +++ bitmap +++ */
typedef struct {
  unsigned char * pxm;
  int width,height;
} bitmap;
#define RGB_FULL  1
#define RGB_TRANS 2
#define VGAFORMAT_VGA  1
#define VGAFORMAT_PPM3 2
#define VGAFORMAT_PPM6 3

#define grafik bitmap
#define CLEAR_BOX(A,B)  vg_bitmap_clear(A,B)
#define GRAFIK_WIDTH(A)   vg_bitmap_width(A)
#define GRAFIK_HEIGHT(A)  vg_bitmap_height(A)

extern unsigned char font10x17[];


/* +++ moving graphics with sound (film) +++ */
typedef struct {  /* each picture of a sequence of a film */
  grafik * pic;             /* graphic */
  int count;                /* counter for steps graphic is shown */
  int count_to;             /* upto steps graphic to show */
  int x,y;                  /* relative x/y coordinates */
  int ft;                   /* RGB_FULL or RGB_TRANS */
  int wnr;                  /* wave number: play, or -1=stop or 0=do nothing */
  int wch;                  /* channel(s) sound to play/stop */
  short wvol;               /* time to in/decrease volume */
} film_bild;

typedef struct _film film;
struct _film {
  grafik ** _pixold,** _pixnew;      /* internal */
  void (*func)(film *,void *,int);   /* film subcall or NULL */
  film_bild *** bild;                /* pointer to sequences */
  int * aktiv;                       /* sequence active? see #defines below */
#define FILM_ACT_OK     0       /* sequence is active */
#define FILM_ACT_SLEEP  1       /* sequence is sleeping: only draw graphic */
#define FILM_ACT_DEAD   2       /* sequence is dead: don't even draw graphic */
  int * bildnr;                      /* current picture number of sequence */
  unsigned long step;                /* step number of film */
  int id,x,y;                        /* ID and x/y coordinates of film */
};

#define SET_FILM(P1,P2,P3,P4,P5)  \
     ((P1)->id=P2,(P1)->x=P3,(P1)->y=P4,(P1)->func=P5)
#define SET_FILM_BILD(P1,P2,P3,P4,P5,P6,P7,P8,P9)  \
     ((P1)->pic=P2,(P1)->x=P3,(P1)->y=P4,(P1)->ft=P5,(P1)->count_to=P6,(P1)->wnr=P7,(P1)->wch=P8,(P1)->wvol=P9)


/* +++ sprite +++ */
typedef struct {
  int max_elem;
  int curr_elem,curr_loop;
  struct {
    int anz_loop;
    bitmap * grf;
    char sname[16];
  } * elem;
} sprite;
#define SPRITE_WIDTH(A)   (((A)!=NULL&&(A)->max_elem>0)?vg_bitmap_width((A)->elem[0].grf):0)
#define SPRITE_HEIGHT(A)  (((A)!=NULL&&(A)->max_elem>0)?vg_bitmap_height((A)->elem[0].grf):0)


/* +++ global variables +++ */
extern char _cwdir[512],_cwdir2[512];
extern int _rgbwhite,_rgbblack,_rgbdark;
#define RGB_WHITE _rgbwhite  /* white pixel */
#define RGB_BLACK _rgbblack  /* black pixel (transparent) */
#define RGB_DARK _rgbdark  /* second black pixel (not transparent) */
#define CWDIR _cwdir  /* game-directory */
extern struct vol_name {
  int anz;
  char vname[VOLUME_MAXNO][25];
  char gname[VOLUME_MAXNO][16];
} volume_name;


/* +++ functions +++ */
/* vgagames2.c */
extern int vg_init_vgagames(const char *,int,const char *);
extern int vg_window_open(const char *,int,int);
extern void vg_window_flush(void);
extern void vg_window_close(void);
extern void vg_key_discard(void);
extern int vg_key_update(void);
extern int vg_key_pressed(int,int);
extern int vg_mouse_found(void);
extern int vg_mouse_x(void);
extern int vg_mouse_y(void);
extern int vg_mouse_pressed(int,int);
extern int vg_mouse_speed(int);
extern int vg_timestamp(int *,int *,int *);
/* color.c */
extern int vg_load_colormap(const char *,char *,size_t);
extern int vg_color_index(int,int);
extern int vg_brightness(int);
/* font.c */
extern int vg_font_width(const char *);
extern int vg_font_height(const char *);
/* bitmap.c */
extern bitmap * vg_bitmap_createnew(int,int);
extern bitmap * vg_bitmap_createfromfile(const char *);
extern bitmap * vg_bitmap_createfromtext(int,int,int,int,const char *,const char *);
extern bitmap * vg_bitmap_duplicate(const bitmap *);
extern int vg_bitmap_width(const bitmap *);
extern int vg_bitmap_height(const bitmap *);
extern int vg_bitmap_getpixel(const bitmap *,int,int);
extern int vg_bitmap_save(const bitmap *,const char *,int);
extern void vg_bitmap_clear(bitmap *,int);
extern void vg_bitmap_copyto(bitmap *,int,int,const bitmap *,int,int,int,int,int);
extern bitmap * vg_bitmap_rotate(const bitmap *,int);
extern bitmap * vg_bitmap_zoom(const bitmap *,double,double);
extern void vg_bitmap_free(bitmap *);
/* draw.c */
extern void vg_draw_text(bitmap *,int,int,int,const char *,const char *,int);
extern void vg_draw_pixel(bitmap *,int,int,int);
extern void vg_draw_line(bitmap *,int,int,int,int,int);
extern void vg_draw_box(bitmap *,int,int,int,int,int,int);
extern void vg_draw_circle(bitmap *,int,int,int,int,int);
extern void vg_draw_fillout(bitmap *,int,int,int);
/* sound.c */
extern int vg_sound_startserver(int,int,const char *);
extern void vg_sound_endserver(void);
extern void vg_sound_attach(const char *,const char *,int);
extern int vg_sound_play(const char *,int,int);
extern void vg_sound_paus(const char *);
extern void vg_sound_cont(const char *);
extern void vg_sound_pate(const char *);
extern void vg_sound_catb(const char *);
extern void vg_sound_stop(const char *,int);
extern void vg_sound_gclr(const char *);
extern void vg_sound_gadd(const char *,const char *);
extern void vg_sound_gdel(const char *,const char *);
extern int vg_sound_volm(const char *,int);
extern void vg_sound_volumename(const char *,const char *);
/* sprite */
extern sprite * vg_sprite_createnew(void);
extern sprite * vg_sprite_createfromfile(const char *);
extern int vg_sprite_add(sprite *,const bitmap *,int,const char *,int);
extern sprite * vg_sprite_duplicate(const sprite *);
extern sprite * vg_sprite_rotate(sprite *,int);
extern sprite * vg_sprite_zoom(sprite *,double,double);
extern bitmap * vg_sprite_getnext(sprite *);
extern bitmap * vg_sprite_getcurrent(const sprite *);
extern void vg_sprite_reset(sprite *);
extern void vg_sprite_free(sprite *);


/* version-1 functions */
extern int wait_time(int);
extern int color_index(int,int);
extern int load_colormap(const char *);
extern void set_font(unsigned char *,int,int);
extern grafik * create_grafik(int,int);
extern grafik * load_grafik(const char *);
extern grafik * text_to_grafik(int,int,int,int,const char *);
extern int save_grafik_as_ppm(grafik *,const char *);
extern int save_grafik_as_ppm3(grafik *,const char *);
extern void free_grafik(grafik *);
extern void copy_grafik(grafik *,int,int,grafik *,int,int,int,int,int);
extern grafik * rotate_grafik(grafik *,grafik *,int,int *,int *,int *,int *);
extern grafik * zoom_grafik(grafik *,grafik *,float,float,int *,int *,int *,int *);
extern int get_pixel(grafik *,int,int);
extern void draw_text(grafik *,int,int,int,const char *,int,int);
extern void draw_pixel(grafik *,int,int,int);
extern void draw_line(grafik *,int,int,int,int,int);
extern void draw_circle(grafik *,int,int,int,int,int);
extern void draw_fillbox(grafik *,int,int,int,int,int);
extern film * create_film(int);
extern int add_bild_to_film(film *,film_bild *,int);
extern unsigned long copy_film(grafik *,film *,void *);
extern void reset_film(film *,void *,int);
extern void free_film(film *);
extern sprite * create_sprite(void);
extern sprite * load_sprite(const char *);
extern sprite * rotate_sprite(sprite *,int);
extern sprite * zoom_sprite(sprite *,float,float);
extern int add_grafik_to_sprite(sprite *,grafik *,int,int,int,int,int);
extern grafik * next_sprite(sprite *,int *,int *);
extern grafik * last_sprite(sprite *,int *,int *);
extern int reset_sprite(sprite *);
extern void free_sprite(sprite *);
/* graphic library dependend functions */
extern int open_window(const char *,int);
extern void flush_window(void);
extern void close_window(void);
extern int reopen_window(int);
extern void get_keys(void);
extern void clearstate(void);
extern int mouse_speed(int);
extern void brightness(int);
/* sound functions */
extern int init_sound(long,int);
extern int load_wave(const char *,int);
extern void play_wave(int,int,short,short);
extern void stop_wave(int,short);
extern void pause_wave(int);
extern void continue_wave(int);
extern void volume_wave(int,short);
extern void accel_wave(short,short);
extern void end_sound(void);
extern int set_vol(int,int);
/* network functions */
extern int start_nettcp(int,int,unsigned short);
extern void * connect_nettcp(const char *,unsigned short,size_t,int *,int *);
extern int talk_nettcp(void);
extern void close_nettcp(void);
/* sound-defines */
#define CN_MAX 8  /* number of channels */
#define CN_ALL 0x7fff  /* all channels */
#define CN_(A)  (1<<(A-1))  /* one channel */
#define TYP_IS_EXTENSION  0  /* sound file type autodetect via file ext. */
#define TYP_IS_WAVE       1  /* sound file type wave */
#define TYP_IS_MIDI       2  /* sound file type midi */
#define TYP_IS_MP3        3  /* sound file type mp3 */


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* VGAGAMES_H_ */
