#!/bin/sh
#
# config-nw.sh: configure values for network into config.h
#

# read in parameters
read CC
test "$CC" = "" && CC="cc"
read CPP
test "$CPP" = "" && CPP="cc -E"
read sharedir

# check echo
ECHO="echo"; ECHOSTRIP="\c"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && ECHO="echo -e"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && { ECHO="echo -n"; ECHOSTRIP=""; }


# ****************************************
# ***** check for network parameters *****
# ****************************************

echo
echo "==> Check for network parameters ..."
(echo; echo) >> config.log
echo "#####################" >> config.log
echo "### Network Tests ###" >> config.log
echo "#####################" >> config.log


# ++++++++++++++++++++++++++++++
# +++ check for sys/sockio.h +++
# ++++++++++++++++++++++++++++++

$ECHO "have sys/sockio.h?                      $ECHOSTRIP"
(echo; echo "*** have sys/sockio.h? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/sockio.h>
int main() {
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
$CC -c _xt.c 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -eq 0
then
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_SYS_SOCKIO_H" >> config.h
else
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_SYS_SOCKIO_H */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# +++++++++++++++++++++++++++++++++++++++++++
# +++ check for sa_len in struct sockaddr +++
# +++++++++++++++++++++++++++++++++++++++++++

$ECHO "have sa_len in struct sockaddr?         $ECHOSTRIP"
(echo; echo "*** have sa_len in struct sockaddr? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
int main() {
  size_t i=sizeof(((struct sockaddr *)0)->sa_len);
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
$CC -c _xt.c 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -eq 0
then
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_SOCKADDR_SA_LEN" >> config.h
else
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_SOCKADDR_SA_LEN */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# +++++++++++++++++++++++++++++
# +++ check for getaddrinfo +++
# +++++++++++++++++++++++++++++

$ECHO "have getaddrinfo?                       $ECHOSTRIP"
(echo; echo "*** have getaddrinfo? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling and searching for addrinfo: $CPP _xt.c") >> config.log
erg1=`$CPP _xt.c 2>> config.log | grep addrinfo`
echo "$erg1" >> config.log
echo "<-- End compiling and searching for addrinfo" >> config.log
if test "$erg1" != ""
then
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_GETADDRINFO" >> config.h
else
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_GETADDRINFO */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# +++++++++++++++++++++++++++
# +++ check for inet_pton +++
# +++++++++++++++++++++++++++

$ECHO "have inet_pton?                         $ECHOSTRIP"
(echo; echo "*** have inet_pton? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling and searching for inet_pton: $CPP _xt.c") >> config.log
erg1=`$CPP _xt.c 2>> config.log | grep inet_pton`
echo "$erg1" >> config.log
echo "<-- End compiling and searching for inet_pton" >> config.log
if test "$erg1" != ""
then
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_INETPTON" >> config.h
else
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_INETPTON */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# +++++++++++++++++++++++++++
# +++ check for inet_ntop +++
# +++++++++++++++++++++++++++

$ECHO "have inet_ntop?                         $ECHOSTRIP"
(echo; echo "*** have inet_ntop? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling and searching for inet_ntop: $CPP _xt.c") >> config.log
erg1=`$CPP _xt.c 2>> config.log | grep inet_ntop`
echo "$erg1" >> config.log
echo "<-- End compiling and searching for inet_ntop" >> config.log
if test "$erg1" != ""
then
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_INETNTOP" >> config.h
else
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_INETNTOP */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# +++++++++++++++++++++++++++
# +++ check for socklen_t +++
# +++++++++++++++++++++++++++

$ECHO "have socklen_t?                         $ECHOSTRIP"
(echo; echo "*** have socklen_t? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/socket.h>
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log 
$CC -c _xt.c 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -eq 0
then
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_SOCKLEN_T" >> config.h
else
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "typedef int socklen_t;" >> config.h
  echo "#define HAVE_SOCKLEN_T" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt



# +++++++++++++++++++++++++++++++++++
# +++ check for network libraries +++
# +++++++++++++++++++++++++++++++++++

$ECHO "check for network libraries:            $ECHOSTRIP"
(echo; echo "*** check for network libraries ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
int main() {
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

erg1=0
for nwlib in "-lsocket -lnsl -lresolv" "-lsocket -lnsl" "-lsocket"
do
  (echo; echo "--> Begin compiling error messages: $CC _xt.c $nwlib -o _xt") >> config.log
  $CC _xt.c $nwlib -o _xt 2>> config.log
  x=$?
  echo "<-- End compiling error messages" >> config.log
  if test $x -eq 0
  then
    echo "\"$nwlib\""
    echo "==> ok" >> config.log
    (echo; echo "==> \"$nwlib\" <==") >> config.log
    rm -f _vg2; cat _vg2.cf | sed -e "s%##NWLIBS##%$nwlib%" > _vg2; mv -f _vg2 _vg2.cf
    erg1=1
    break
  fi
  echo "==> wrong" >> config.log
done
if test $erg1 -eq 0
then
  echo "[none]"
  (echo; echo "==> [none] <==") >> config.log
  rm -f _vg2; cat _vg2.cf | sed -e "s%##NWLIBS##%%" > _vg2; mv -f _vg2 _vg2.cf
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# ++++++++++++++++++++++++++
# +++ Network tests done +++
# ++++++++++++++++++++++++++

echo "<== network parameter tests done"
exit 0
