#!/bin/sh
#
# config-sound.sh: define found sound devices into config.h
#

# read in parameters
read CC
test "$CC" = "" && CC="cc"
read CPP
test "$CPP" = "" && CPP="cc -E"
read sharedir

# check echo
ECHO="echo"; ECHOSTRIP="\c"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && ECHO="echo -e"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && { ECHO="echo -n"; ECHOSTRIP=""; }


# ***********************************
# ***** check for sound devices *****
# ***********************************

echo
echo "==> Check for sound devices ..."
(echo; echo) >> config.log
echo "###########################" >> config.log
echo "### Sound devices Tests ###" >> config.log
echo "###########################" >> config.log


# +++++++++++++++++++++
# +++ check for OSS +++
# +++++++++++++++++++++

$ECHO "have OSS?                               $ECHOSTRIP"
(echo; echo "*** have OSS? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/soundcard.h>
int main() {
  int fd;
  fd=open("/dev/dsp",O_WRONLY);
  if (fd<0) {
    if ((errno==ENOENT) || (errno==ENODEV)) {return(1);}
  } else {close(fd);}
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC _xt.c -o _xt") >> config.log
$CC _xt.c -o _xt 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -eq 0
then
  (echo; echo "--> Begin executing ./_xt") >> config.log
  ./_xt 2>> config.log
  x=$?
  echo "<-- End executing with return status $x" >> config.log
  if test $x -eq 0
  then
    echo "yes"
    (echo; echo "==> yes <==") >> config.log
    echo "#define HAVE_SOUND_OSS" >> config.h
  fi
fi
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_SOUND_OSS */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# ++++++++++++++++++++++++++
# +++ check for ALSA 0.9 +++
# ++++++++++++++++++++++++++

$ECHO "have ALSA 0.9?                          $ECHOSTRIP"
(echo; echo "*** have ALSA 0.9? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#define ALSA_PCM_NEW_HW_PARAMS_API
#define ALSA_PCM_NEW_SW_PARAMS_API
#include <alsa/asoundlib.h>
int main() {
  snd_pcm_stream_t stream=SND_PCM_STREAM_PLAYBACK;
  snd_pcm_t * pcm;
  int err=snd_pcm_open(&pcm,"default",stream,SND_PCM_NONBLOCK);
  if (err<0) {
    if ((err!=-EACCES) && (err!=-EBUSY)) {return(1);}
  } else {
    snd_pcm_hw_params_t * hw;
    int hw_dir=0;
    unsigned int rate;
    if (0) snd_pcm_hw_params_set_rate_near(pcm,hw,&rate,&hw_dir);
    snd_pcm_close(pcm);
  }
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC _xt.c -lasound -o _xt") >> config.log
erg1=`$CC _xt.c -lasound -o _xt 2>&1`
x=$?
echo "$erg1" >> config.log
echo "<-- End compiling error messages" >> config.log
if test $x -eq 0
then
  (echo; echo "--> Begin executing ./_xt") >> config.log
  ./_xt 2>> config.log
  x=$?
  echo "<-- End executing with return status $x" >> config.log
  if test $x -eq 0
  then
    if echo "$erg1" | grep set_rate_near > /dev/null
    then
      echo "incomplete (too old ALSA-style found)"
      (echo; echo "==> incomplete (too old ALSA-style found) <==") >> config.log
      echo "/* #undef HAVE_SOUND_ALSA09 */" >> config.h
      rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_SOUND_ALSA09##%0%" > _vg2; mv -f _vg2 _vg2.mk
    else
      echo "yes"
      (echo; echo "==> yes <==") >> config.log
      echo "#define HAVE_SOUND_ALSA09" >> config.h
      rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_SOUND_ALSA09##%1%" > _vg2; mv -f _vg2 _vg2.mk
    fi
  fi
fi
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_SOUND_ALSA09 */" >> config.h
  rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_SOUND_ALSA09##%0%" > _vg2; mv -f _vg2 _vg2.mk
fi
(echo; echo "####################") >> config.log
rm -f _xt _xt.c _xt.o


# +++++++++++++++++++++++++++
# +++ check for Sun audio +++
# +++++++++++++++++++++++++++

$ECHO "have SUN-AUDIO?                         $ECHOSTRIP"
(echo; echo "*** have SUN-AUDIO? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/audioio.h>
#ifndef AUDIO_ENCODING_ULINEAR_LE
  #define AUDIO_ENCODING_ULINEAR_LE AUDIO_ENCODING_LINEAR8
#endif
#ifndef AUDIO_ENCODING_SLINEAR_LE
  #define AUDIO_ENCODING_SLINEAR_LE AUDIO_ENCODING_LINEAR
#endif
int main() {
  int fd;
  audio_info_t auinfo;
  if ((fd=open("/dev/audio",O_WRONLY))<0) {
    if (errno==EBUSY) {return(0);}
    return(1);
  }
  AUDIO_INITINFO(&auinfo);
  auinfo.play.encoding=AUDIO_ENCODING_SLINEAR_LE;
  auinfo.play.precision=16;
  if (ioctl(fd,AUDIO_SETINFO,&auinfo)<0) {
    AUDIO_INITINFO(&auinfo);
    auinfo.play.encoding=AUDIO_ENCODING_ULINEAR_LE;
    auinfo.play.precision=8;
    if (ioctl(fd,AUDIO_SETINFO,&auinfo)<0) {close(fd); return(1);}
  }
  close(fd);
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC _xt.c -o _xt") >> config.log
$CC _xt.c -o _xt 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
erg1=0
if test $x -eq 0
then
  (echo; echo "--> Begin executing ./_xt") >> config.log
  ./_xt 2>> config.log
  x=$?
  echo "<-- End executing with return status $x" >> config.log
  if test $x -eq 0
  then
    echo "yes"
    (echo; echo "==> yes <==") >> config.log
    echo "#define HAVE_SOUND_SAUDIO" >> config.h
    erg1=1
  else
    echo "- incomplete (device or linear mode failure?)"
    (echo; echo "==> no (incomplete) <==") >> config.log
    echo "/* #undef HAVE_SOUND_SAUDIO */" >> config.h
  fi
fi
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_SOUND_SAUDIO */" >> config.h
fi
rm -f _xt _xt.c _xt.o

if test $erg1 -eq 1
then
  $ECHO "have SUN-AUDIO-BLOCKSIZE?               $ECHOSTRIP"
  (echo; echo "*** Have SUN-AUDIO-BLOCKSIZE? ***") >> config.log
  cat > _xt.c <<__EOF__
#include <sys/types.h>
#include <sys/audioio.h>
int main() {
  audio_info_t auinfo;
  auinfo.hiwat=2;
  auinfo.blocksize=(1<<9);
  return(0);
}
__EOF__
  (echo; echo "--> Begin test file _xt.c:") >> config.log
  cat _xt.c >> config.log
  echo "<-- End test file" >> config.log
  (echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
  $CC -c _xt.c 2>> config.log
  x=$?
  echo "<-- End compiling error messages" >> config.log
  if test $x -eq 0
  then
    echo "yes"
    (echo; echo "==> yes <==") >> config.log
    echo "#define HAVE_SOUND_SAUDIOBLKSZ" >> config.h
  else
    echo "no"
    (echo; echo "==> no <==") >> config.log
    echo "/* #undef HAVE_SOUND_SAUDIOBLKSZ */" >> config.h
  fi
  rm -f _xt.c _xt.o
else
  echo "/* #undef HAVE_SOUND_SAUDIOBLKSZ */" >> config.h
fi

if test $erg1 -eq 1
then
  $ECHO "have SUN-AUDIO-MIXER?                   $ECHOSTRIP"
  (echo; echo "*** Have SUN-AUDIO-MIXER? ***") >> config.log
  cat > _xt.c <<__EOF__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/audioio.h>
int main() {
  mixer_ctrl_t mixctrl;
  mixer_devinfo_t mixdev;
  mixdev.index=1;
  mixctrl.dev=1;
  mixdev.type=AUDIO_MIXER_CLASS;
  mixdev.type=AUDIO_MIXER_VALUE;
  ioctl(1,AUDIO_MIXER_READ,&mixctrl);
  ioctl(1,AUDIO_MIXER_WRITE,&mixctrl);
  return(0);
}
__EOF__
  (echo; echo "--> Begin test file _xt.c:") >> config.log
  cat _xt.c >> config.log
  echo "<-- End test file" >> config.log
  (echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
  $CC -c _xt.c 2>> config.log
  x=$?
  echo "<-- End compiling error messages" >> config.log
  if test $x -eq 0
  then
    echo "yes"
    (echo; echo "==> yes <==") >> config.log
    echo "#define HAVE_SOUND_SAUDIOMIXER" >> config.h
  else
    echo "no"
    (echo; echo "==> no <==") >> config.log
    echo "/* #undef HAVE_SOUND_SAUDIOMIXER */" >> config.h
  fi
  rm -f _xt.c _xt.o
else
  echo "/* #undef HAVE_SOUND_SAUDIOMIXER */" >> config.h
fi
(echo; echo "####################") >> config.log


# ++++++++++++++++++++++++++++++++
# +++ sound devices tests done +++
# ++++++++++++++++++++++++++++++++

echo "<== sound devices tests done"
exit 0
