#!/bin/sh
#
# config-support.sh: define not-supported functions into config.h
#

# read in parameters
read CC
test "$CC" = "" && CC="cc"
read CPP
test "$CPP" = "" && CPP="cc -E"
read sharedir

# check echo
ECHO="echo"; ECHOSTRIP="\c"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && ECHO="echo -e"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && { ECHO="echo -n"; ECHOSTRIP=""; }


# *********************************************
# ***** check for not supported functions *****
# *********************************************

echo
echo "==> Check for not supported functions ..."
(echo; echo) >> config.log
echo "#####################################" >> config.log
echo "### Not-supported functions Tests ###" >> config.log
echo "#####################################" >> config.log


# +++++++++++++++++++++++++
# +++ check for strlcpy +++
# +++++++++++++++++++++++++

$ECHO "have strlcpy?                           $ECHOSTRIP"
(echo; echo "*** have strlcpy? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
int main() {
  char buf[32]="";
  strlcpy(buf,"123",sizeof(buf));
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC _xt.c -o _xt") >> config.log
$CC _xt.c -o _xt 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_STRLCPY */" >> config.h
else
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_STRLCPY" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# +++++++++++++++++++++++++
# +++ check for strlcat +++
# +++++++++++++++++++++++++

$ECHO "have strlcat?                           $ECHOSTRIP"
(echo; echo "*** have strlcat? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
int main() {
  char buf[32]="";
  strlcat(buf,"123",sizeof(buf));
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC _xt.c -o _xt") >> config.log
$CC _xt.c -o _xt 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_STRLCAT */" >> config.h
else
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_STRLCAT" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# ++++++++++++++++++++++++++++++++++++++++++
# +++ Not-supported functions tests done +++
# ++++++++++++++++++++++++++++++++++++++++++

echo "#include \"vgag_support.h\"" >> config.h

echo "<== not-supported functions tests done"
exit 0
